/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;

/**
 * @author Kota Mizushima
 *  
 */
public class InterfaceMethodDeclaration extends SimpleASTNode {
  
  private final String name;
  
  private final ArgumentDeclaration[] arguments;
  
  private final TypeSpecifier returnType;

  public InterfaceMethodDeclaration(String name, ArgumentDeclaration[] arguments, TypeSpecifier returnType) {
    this.name = name;
    this.arguments = arguments;
    this.returnType = returnType;
    setChildren(arguments);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
  
  public String getName(){
    return name;
  }
  
  public TypeSpecifier getReturnType() {
    return returnType;
  }

  public ArgumentDeclaration[] getArguments() {
    return arguments;
  }
  
}