/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;


/**
 * @author Kota Mizushima
 *  
 */
public class ConstructorDeclaration extends MemberDeclaration {
  
  private final ArgumentDeclaration[] arguments;

  private final BlockStatement block;

  private final Expression[] initializers;
  
  public ConstructorDeclaration(ArgumentDeclaration[] arguments, Expression[] initializers, BlockStatement block) {
    super("new");
    this.arguments = arguments;
    this.block = block;
    this.initializers = initializers;
    setChildren(arguments);
    setChildren(initializers);
    setChild(block);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }

  public BlockStatement getBlock() {
    return block;
  }
  
  public Expression[] getInitializers(){
    return (Expression[])initializers.clone();
  }
  
  public ArgumentDeclaration[] getArguments(){
    return (ArgumentDeclaration[])arguments.clone();
  }
  
}