/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.compiler.environment.ClosureLocalBinding;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class LocalRefNode extends ExpressionNode {
  private int frame;
  private int index;
  private TypeSymbol type;

  public LocalRefNode(ClosureLocalBinding bind) {
    this.frame = bind.getFrame();
    this.index = bind.getIndex();
    this.type = bind.getType();
  }
  
  public LocalRefNode(int frame, int index, TypeSymbol type){
    this.frame = frame;
    this.index = index;
    this.type = type;
  }
  
  public int frame(){ return frame; }
  
  public int index(){ return index; }
  
  public TypeSymbol type() { return type; }
}
