/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/06/17
 */
public class DoubleNode extends ExpressionNode {
  private final double value;
  
  public DoubleNode(double value) {
    this.value = value;
  }
  
  public double getValue() {
    return value;
  }
  
  public TypeSymbol type() { 
    return BasicSymbol.DOUBLE; 
  }
}