/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.utility;

import org.onion_lang.onion.compiler.environment.ClassTable;
import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.NewNode;
import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/07/10
 */
public class Boxing {
  private static final Object[][] TABLE = {
    {BasicSymbol.BOOLEAN, "java.lang.Boolean"},
    {BasicSymbol.BYTE, "java.lang.Byte"},
    {BasicSymbol.SHORT, "java.lang.Short"},
    {BasicSymbol.CHAR, "java.lang.Character"},
    {BasicSymbol.INT, "java.lang.Integer"},
    {BasicSymbol.LONG, "java.lang.Long"},
    {BasicSymbol.FLOAT, "java.lang.Float"},
    {BasicSymbol.DOUBLE, "java.lang.Double"},
  };
  
  private Boxing() {
  }
  
  private static ClassSymbol boxedType(ClassTable table, BasicSymbol type){
    for(int i  = 0; i < TABLE.length; i++){
      if(TABLE[i][0] == type){
        return table.load(((String)TABLE[i][1]));
      }
    }
    throw new RuntimeException("");
  }
  
  public static ExpressionNode boxing(ClassTable table, ExpressionNode node){
    TypeSymbol type = node.type();
    if((!type.isBasicType()) || type == BasicSymbol.VOID){
      throw new IllegalArgumentException("node type must be boxable type");
    }
    ClassSymbol boxedType = boxedType(table, (BasicSymbol)type);
    ConstructorSymbol[] cs = boxedType.getConstructors();
    for(int i = 0; i < cs.length; i++){
      TypeSymbol[] args = cs[i].getArguments();
      if(args.length == 1 && args[i] == type){
        return new NewNode(cs[i], new ExpressionNode[]{node});
      }
    }
    throw new RuntimeException("couldn't find matched constructor");
  }
}
