/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment.javawrapper;

import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/06/27
 */
public class ClassFileMethodSymbol implements MethodSymbol {
  private int modifier;
  private ClassSymbol classType;  
  private String name;
  private TypeSymbol[] arguments;
  private TypeSymbol returnType;

  public ClassFileMethodSymbol(
    int modifier, ClassSymbol classType, String name, 
    TypeSymbol[] arguments, TypeSymbol returnType) {
    this.modifier = modifier;
    this.classType = classType;
    this.name = name;
    this.arguments = (TypeSymbol[]) arguments.clone();
    this.returnType = returnType;
  }
  
  public int getModifier(){
    return modifier;
  }

  public ClassSymbol getClassType() {
    return classType;
  }

  public String getName() {
    return name;
  }

  public TypeSymbol[] getArguments() {
    return arguments;
  }

  public TypeSymbol getReturnType() {
    return returnType;
  }
}
