/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler;

import java.util.HashMap;
import java.util.Map;

import org.onion_lang.onion.lang.syntax.ASTNode;
import org.onion_lang.onion.lang.syntax.SourcePosition;

/**
 * @author Kota Mizushima
 * Date: 2005/04/09
 */
public class SourcePositionBindings {
  
  private HashMap bindings = new HashMap();

  public SourcePositionBindings(){
  }

  public void put(ASTNode node, SourcePosition position){
    bindings.put(node, position);
  }
  
  public SourcePosition get(ASTNode node){
    return (SourcePosition) bindings.get(node);
  }
  
  public Map getBindings(){
    return (Map)bindings.clone();
  }
  
}
