/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler;

import java.io.File;
import java.net.*;
import java.net.URL;
import java.net.URLClassLoader;

/**
 * @author Kota Mizushima
 * Date: 2005/07/19
 */
public class OnionClassLoader extends URLClassLoader {
  public OnionClassLoader(
    String[] classpath, ClassLoader parent,CompiledClass[] classes
  ) throws MalformedURLException {
    super(getURLs(classpath), parent);
    for(int i = 0; i < classes.length; i++){
      String className = classes[i].getClassName();
      byte[] content = classes[i].getContent();
      defineClass(className, content, 0, content.length);
    }
  }
  
  protected Class findClass(String name) throws ClassNotFoundException {
    return super.findClass(name);
  }
  
  private static URL[] getURLs(String[] classpath) throws MalformedURLException {
    URL[] urls = new URL[classpath.length];
    for(int i = 0; i < classpath.length; i++) {
      urls[i] = new File(classpath[i]).toURL();
    }
    return urls;
  }
}