unit OleDnDUtils;

// $Id: OleDnDUtils.pas,v 1.7 2002/05/07 14:04:07 takao Exp $

{$ObjExportAll On}

interface

uses
  Classes, Windows, SysUtils, ShlObj, ActiveX;

type
  TDropEffect = (ekNone, ekCopy, ekMove, ekLink);
  TDropEffects = set of TDropEffect;

function GetDropEffects(aKind: DWord): TDropEffects;
function GetDropEffect(aKind: DWord): TDropEffect;
function GetDropEffectValue(effects: TDropEffects): DWord;
function GetStdDropEffect(aKeyState: DWord): TDropEffect;

function GetShellFolder(const aDirectory: string): IShellFolder;
function GetFileItemID(aFolder: IShellFolder; const aFilename: string): PItemIDList;
function GetFileDataObject(
  aWnd: HWnd; const aDirectory: string; files: TStrings): IDataObject; overload;
function GetFileDataObject(
  aWnd: HWnd; const aFilename: string): IDataObject; overload;

procedure GetCFNames(aProc: TGetStrProc);
function GetCFName(aFormat: Word): string;
function GetCFValue(const aName: string): Word;

var
  ekAll: TDropEffects = [ekCopy, ekMove, ekLink];


implementation

//uses
//  FileCtrl;

{ DONE: Mozilla, Netscape, IE  CF ǉ }

var
  IID_IDataObject: TGUID = (
    D1:$0000010E;D2:$0000;D3:$0000;D4:($C0,$00,$00,$00,$00,$00,$00,$46));


function GetDropEffects(aKind: DWord): TDropEffects;
begin
  if (aKind and DROPEFFECT_COPY) <> 0 then Include(Result, ekCopy);
  if (aKind and DROPEFFECT_MOVE) <> 0 then Include(Result, ekMove);
  if (aKind and DROPEFFECT_LINK) <> 0 then Include(Result, ekLink);
end;

function GetDropEffect(aKind: DWord): TDropEffect;
begin
  case aKind of
    DROPEFFECT_COPY: Result := ekCopy;
    DROPEFFECT_MOVE: Result := ekMove;
    DROPEFFECT_LINK: Result := ekLink;
  else
    Result := ekNone;
  end;
end;

function GetDropEffectValue(effects: TDropEffects): DWord;
begin
  Result := DROPEFFECT_NONE;
  if ekCopy in effects then Result := Result or DROPEFFECT_COPY;
  if ekMove in effects then Result := Result or DROPEFFECT_MOVE;
  if ekLink in effects then Result := Result or DROPEFFECT_LINK;
end;

function GetStdDropEffect(aKeyState: DWord): TDropEffect;
var
  shift: Boolean;
  ctrl: Boolean;
begin
  shift := (aKeyState and MK_SHIFT ) <> 0;
  ctrl := (aKeyState and MK_CONTROL) <> 0;

  if shift and (not ctrl) then    // shift only
    Result := ekMove
  else if shift and ctrl then  // shift && ctrl
    Result := ekLink
  else          // ctrl only or no key
    Result := ekCopy;
end;

function GetShellFolder(const aDirectory: string): IShellFolder;
var
  desktop: IShellFolder;
  itemID: PItemIDList;
begin
  Result := Nil;

  if not (DirectoryExists(aDirectory) or FileExists(aDirectory)) then
    raise Exception.Create('pX ' + aDirectory + ' ݂͑܂.');

  desktop := Nil;
  if FAILED(SHGetDesktopFolder(desktop)) then Exit;
  itemID := GetFileItemID(desktop, aDirectory);
   if itemID <> Nil then begin
     desktop.BindToObject(itemID, Nil, IID_IShellFolder, Result);
  end;
end;

function GetFileItemID(aFolder: IShellFolder; const aFilename: string): PItemIDList;
var
  wpath: WideString;
  eaten: DWord;
  attributes: DWord;
  ret: HResult;
begin
  wpath := aFilename;
  eaten := 0;
  attributes := 0;
  ret := aFolder.ParseDisplayName(0, Nil, PWideChar(wpath), eaten, Result, attributes);
  if FAILED(ret) then
    raise Exception.Create('pX "' + aFilename + '" ͖ł.');
end;

function GetFileDataObject(aWnd: HWnd; const aDirectory: string;
  files: TStrings): IDataObject;
type
  PPItemIDList = ^PItemIDList;
var
  i: Integer;
  n: Integer;
  folder: IShellFolder;
  allocator: IMalloc;
  itemIDs: array of PItemIDList;
  itemID: PPItemIDList;
begin
  Result := Nil;

  n := files.Count;
  if (n <= 0) or (n > 1024) then Exit;

  folder := GetShellFolder(aDirectory);
  if folder = Nil then Exit;

  allocator := Nil;
  if FAILED(SHGetMalloc(allocator)) then Exit;

  SetLength(itemIDs, n);
  for i := 0 to n - 1 do begin
     itemIDs[i] := GetFileItemID(folder, files[i]);
  end;
  itemID := PPItemIDList(itemIDs);
  folder.GetUIObjectOf(aWnd, n, itemID^, IID_IDataObject, Nil, Result);

  for i := 0 to n - 1 do begin
    allocator.Free(itemIDs[i]);
  end;
end;

function GetFileDataObject(aWnd: HWnd; const aFilename: string): IDataObject;
var
  dir: string;
  filename: string;
  list: TStringList;
begin
  dir := ExtractFileDir(aFilename);
  filename := ExtractFileName(aFilename);
  list := TStringList.Create;
  Result := Nil;
  try
    list.Add(filename);
    Result := GetFileDataObject(aWnd, dir, list);
  finally
    list.Free;
  end;
end;


const
  FormatValues: array[0..21] of Word = (
    CF_BITMAP
    , CF_DIB
    , CF_DIF
    , CF_DSPBITMAP
    , CF_DSPENHMETAFILE
    , CF_DSPMETAFILEPICT
    , CF_DSPTEXT
    , CF_ENHMETAFILE
    , CF_HDROP
    , CF_LOCALE
    , CF_MAX
    , CF_METAFILEPICT
    , CF_OEMTEXT
    , CF_OWNERDISPLAY
    , CF_PALETTE
    , CF_PENDATA
    , CF_RIFF
    , CF_SYLK
    , CF_TEXT
    , CF_TIFF
    , CF_UNICODETEXT
    , CF_WAVE
  );
  FormatNames: array[0..21] of string = (
    'CF_BITMAP'
    , 'CF_DIB'
    , 'CF_DIF'
    , 'CF_DSPBITMAP'
    , 'CF_DSPENHMETAFILE'
    , 'CF_DSPMETAFILEPICT'
    , 'CF_DSPTEXT'
    , 'CF_ENHMETAFILE'
    , 'CF_HDROP'
    , 'CF_LOCALE'
    , 'CF_MAX'
    , 'CF_METAFILEPICT'
    , 'CF_OEMTEXT'
    , 'CF_OWNERDISPLAY'
    , 'CF_PALETTE'
    , 'CF_PENDATA'
    , 'CF_RIFF'
    , 'CF_SYLK'
    , 'CF_TEXT'
    , 'CF_TIFF'
    , 'CF_UNICODETEXT'
    , 'CF_WAVE'
  );
  ExCFNames: array[0..19] of string = (
    'Shell IDList Array'     // CF_IDLIST
    , 'Shell Object Offsets' // CF_OBJECTPOSITIONS
    , 'Net Resource'         // CF_NETRESOURCE
    , 'FileGroupDescriptor'  // CF_FILEGROUPDESCRIPTORA
    , 'FileGroupDescriptorW' // CF_FILEGROUPDESCRIPTORW
    , 'FileContents'         // CF_FILECONTENTS
    , 'FileName'             // CF_FILENAMEA
    , 'FileNameW'            // CF_FILENAMEW
    , 'PrinterFriendlyName'  // CF_PRINTERS
    , 'FileNameMap'          // CF_FILENAMEMAPA
    , 'FileNameMapW'         // CF_FILENAMEMAPW
    , 'UniformResourceLocator'
    , 'UniformResourceLocatorW'
    //from owl
    , 'Rich Text Format'
    , 'Embed Source'
    , 'Embedded Object'
    , 'Link Source'
    , 'Object Descriptor'
    , 'Link Source Descriptor'
    // netscape
    , 'Netscape Bookmark'       // netscape
  );

procedure GetCFNames(aProc: TGetStrProc);
var
  i: Integer;
begin
  for i := 0 to 19 do
    aProc(FormatNames[i]);
  for i := 0 to 17 do
    aProc(ExCFNames[i]);
end;

function GetCFName(aFormat: Word): string;
var
  name: string;
begin
  case aFormat of
    CF_TEXT:         Result := 'CF_TEXT';
    CF_BITMAP:       Result := 'CF_BITMAP';
    CF_METAFILEPICT: Result := 'CF_METAFILEPICT';
    CF_SYLK:         Result := 'CF_SYLK';
    CF_DIF:           Result := 'CF_DIF';
    CF_TIFF:         Result := 'CF_TIFF';
    CF_OEMTEXT:       Result := 'CF_OEMTEXT';
    CF_DIB:           Result := 'CF_DIB';
    CF_PALETTE:       Result := 'CF_PALETTE';
    CF_PENDATA:       Result := 'CF_PENDATA';
    CF_RIFF:         Result := 'CF_RIFF';
    CF_WAVE:         Result := 'CF_WAVE';
    CF_UNICODETEXT:   Result := 'CF_UNICODETEXT';
    CF_ENHMETAFILE:   Result := 'CF_ENHMETAFILE';
    CF_HDROP:         Result := 'CF_HDROP';
    CF_LOCALE:       Result := 'CF_LOCALE';
    CF_MAX:           Result := 'CF_MAX';
    CF_OWNERDISPLAY: Result := 'CF_OWNERDISPLAY';
    CF_DSPTEXT:       Result := 'CF_DSPTEXT';
    CF_DSPBITMAP:     Result := 'CF_DSPBITMAP';
    CF_DSPMETAFILEPICT:  Result := 'CF_DSPMETAFILEPICT';
    CF_DSPENHMETAFILE:  Result := 'CF_DSPENHMETAFILE';
  else
    SetLength(name, 255);
    if GetClipboardFormatName(aFormat, PChar(name), 255) <> 0 then
      Result := PChar(name);
  end;
end;

function GetCFValue(const aName: string): Word;
var
  i: Integer;
begin
  if Copy(aName, 1, 3) = 'CF_' then
    for i := 0 to 19 do begin
      if aName = FormatNames[i] then begin
        Result := FormatValues[i];
        Exit;
      end;
    end;

  Result := Word(RegisterClipboardFormat(PChar(aName)));
end;


end.
