unit OleDnDImpl;

// $Id: OleDnDImpl.pas,v 1.4 2002/02/25 17:56:56 takao Exp $

{$ObjExportAll On}

interface

uses
  Windows, ActiveX;

{$HPPEMIT '#if __BORLANDC__ >= 0x0550'}
{$HPPEMIT '#  ifndef NO_WIN32_LEAN_AND_MEAN'}
{$HPPEMIT '#    error vWFNg̏ NO_WIN32_LEAN_AND_MEAN ărhĂ.'}
{$HPPEMIT '#  endif'}
{$HPPEMIT '#endif'}
{$HPPEMIT '#include <shlobj.h>'}

type
  { Event Types for TDropSourceImpl }
  TQueryContinueDragEvent = procedure(anEscapePressed: Boolean;
    aKeyState: Integer; var aResult: HResult) of Object;
  TGiveFeedbackEvent = procedure(aDropEffect: Longint; var aResult: HResult)
    of Object;

  { Events Holder for IDropSourceBroker }
  TIDropSourceEvents = class
  public
    OnQueryContinueDrag: TQueryContinueDragEvent;
    OnGiveFeedback: TGiveFeedbackEvent;
  end;

  { IDropSourceBroker }
  IDropSourceBroker = interface(IDropSource)
    function GetEvents: TIDropSourceEvents;
    property Events: TIDropSourceEvents read GetEvents;
  end;

  { TDropSourceImpl }
  TDropSourceImpl = class(TInterfacedObject, IDropSourceBroker)
  private
    FEvents: TIDropSourceEvents;
  public
    constructor Create;
    destructor Destroy; override;

    { IDropSource }
    function QueryContinueDrag(fEscapePressed: BOOL;
      grfKeyState: Longint): HResult; stdcall;
    function GiveFeedback(dwEffect: Longint): HResult; stdcall;
    { IDropSourceBroker }
    function GetEvents: TIDropSourceEvents;
  end;

  { Event Types for TDropTargetImpl }
  TDragEnterEvent = procedure(
    const aDataObject: IDataObject; aKeyState: Longint; aPoint: TPoint;
    var aDropEffect: Longint; var aResult: HResult) of Object;
  TDragOverEvent = procedure(
    aKeyState: Longint; aPoint: TPoint;
    var aDropEffect: Longint; var aResult: HResult) of Object;
  TDragLeaveEvent = procedure(var aResult: HResult) of Object;
  TDropEvent = procedure(
    const aDataObj: IDataObject; aKeyState: Longint; aPoint: TPoint;
    var aDropEffect: Longint; var aResult: HResult) of Object;

  { Events Holder for IDropTargetBroker }
  TIDropTargetEvents = class
  public
    OnDragEnter: TDragEnterEvent;
    OnDragOver: TDragOverEvent;
    OnDragLeave: TDragLeaveEvent;
    OnDrop: TDropEvent;
  end;

  { IDropTargetBroker }
  IDropTargetBroker = interface(IDropTarget)
    function GetEvents: TIDropTargetEvents;
    function GetDataObject: IDataObject;
    function GetDropEffect: Longint;
    property Events: TIDropTargetEvents read GetEvents;
    property DataObject: IDataObject read GetDataObject;
    property DropEffect: Longint read GetDropEffect;
  end;


  { TDropTargetImpl }
  TDropTargetImpl = class(TInterfacedObject, IDropTargetBroker)
  private
    FEvents: TIDropTargetEvents;
    FDropEffect: Longint;
    FDataObject: IDataObject;

  public
    constructor Create;
    destructor Destroy; override;

    { IDropTarget }
    function DragEnter(const dataObj: IDataObject; grfKeyState: Longint;
      pt: TPoint; var dwEffect: Longint): HResult; stdcall;
    function DragOver(grfKeyState: Longint; pt: TPoint;
      var dwEffect: Longint): HResult; stdcall;
    function DragLeave: HResult; stdcall;
    function Drop(const dataObj: IDataObject; grfKeyState: Longint; pt: TPoint;
      var dwEffect: Longint): HResult; stdcall;
    { IDropTargetBroker }
    function GetEvents: TIDropTargetEvents;
    function GetDataObject: IDataObject;
    function GetDropEffect: Longint;
  end;


implementation

{ TDropSourceImpl }

constructor TDropSourceImpl.Create;
begin
  inherited;
  FEvents := TIDropSourceEvents.Create;
end;

destructor TDropSourceImpl.Destroy;
begin
  FEvents.Free;
  inherited;
end;

function TDropSourceImpl.GiveFeedback(dwEffect: Integer): HResult;
begin
  Result := DRAGDROP_S_USEDEFAULTCURSORS;

  if Assigned(FEvents.OnGiveFeedback) then
    FEvents.OnGiveFeedback(dwEffect, Result);
end;

function TDropSourceImpl.QueryContinueDrag(fEscapePressed: BOOL;
  grfKeyState: Integer): HResult;
var
  lButton: Boolean;
  rButton: Boolean;
begin
  lButton := (grfKeyState and MK_LBUTTON) <> 0;
  rButton := (grfKeyState and MK_RBUTTON) <> 0;

  if fEscapePressed then
    Result := DRAGDROP_S_CANCEL
  else if lButton and rButton then
    Result := DRAGDROP_S_CANCEL
  else if (not lButton) and (not rButton) then
    Result := DRAGDROP_S_DROP
  else
    Result := NOERROR;

  if Assigned(FEvents.OnQueryContinueDrag) then
    FEvents.OnQueryContinueDrag(fEscapePressed, grfKeyState, Result);
end;

function TDropSourceImpl.GetEvents: TIDropSourceEvents;
begin
  Result := FEvents;
end;


{ TDropTargetImpl }

constructor TDropTargetImpl.Create;
begin
  inherited;
  FEvents := TIDropTargetEvents.Create;
end;

destructor TDropTargetImpl.Destroy;
begin
  FEvents.Free;
  inherited;
end;

function TDropTargetImpl.DragEnter(const dataObj: IDataObject;
  grfKeyState: Integer; pt: TPoint; var dwEffect: Integer): HResult;
begin
  FDataObject := dataObj;
  FDropEffect := dwEffect;

  Result := S_OK;

  if Assigned(FEvents.OnDragEnter) then
    FEvents.OnDragEnter(dataObj, grfKeyState, pt, dwEffect, Result);
end;

function TDropTargetImpl.DragLeave: HResult;
begin
  FDropEffect := DROPEFFECT_NONE;

  Result := S_OK;

  if Assigned(FEvents.OnDragLeave) then FEvents.OnDragLeave(Result);

  FDataObject := Nil;
end;

function TDropTargetImpl.DragOver(grfKeyState: Integer; pt: TPoint;
  var dwEffect: Integer): HResult;
begin
  FDropEffect := dwEffect;

  Result := S_OK;

  if Assigned(FEvents.OnDragOver) then
    FEvents.OnDragOver(grfKeyState, pt, dwEffect, Result);
end;

function TDropTargetImpl.Drop(const dataObj: IDataObject;
  grfKeyState: Integer; pt: TPoint; var dwEffect: Integer): HResult;
begin
  FDataObject := dataObj;
  Result := S_OK;
  dwEffect := DROPEFFECT_NONE;
  FDropEffect := DROPEFFECT_NONE;

  if Assigned(FEvents.OnDrop) then
    FEvents.OnDrop(dataObj, grfKeyState, pt, dwEffect, Result);

  FDataObject := Nil;
end;

function TDropTargetImpl.GetEvents: TIDropTargetEvents;
begin
  Result := FEvents;
end;

function TDropTargetImpl.GetDataObject: IDataObject;
begin
  Result := FDataObject;
end;

function TDropTargetImpl.GetDropEffect: Longint;
begin
  Result := FDropEffect;
end;


end.
