unit TestCaseTWinMessageSnatcher;

// $Id: TestCaseTWinMessageSnatcher.pas,v 1.1 2002/03/19 15:10:46 takao Exp $

interface

uses
  TestFrameWork, MSGSnatchers;

type
  TTestCaseTWinMessageSnatcher = class(TTestCase)
  private
    snatcher_: TWinMessageSnatcher;
  protected
    procedure Setup; override;
    procedure TearDown; override;
  published
    procedure TestOnFinalizeHWNDFired;
    procedure TestOnInitializeHWNDFired;
  end;

implementation

uses
  Forms, Windows;

type
  { THWNDEventReceiver }
  THWNDEventReceiver = class
  private
    FReceived: Boolean;
  public
    procedure HWNDEvent(aSender: TObject; aHandle: HWND);
    property Received: Boolean read FReceived write FReceived;
  end;

{ THWNDEventReceiver }
procedure THWNDEventReceiver.HWNDEvent(aSender: TObject;
  aHandle: HWND);
begin
  FReceived := True;
end;


{ TTestCaseTWinMessageSnatcher }

procedure TTestCaseTWinMessageSnatcher.Setup;
begin
  inherited;
  snatcher_ := TWinMessageSnatcher.Create(Application);
end;

procedure TTestCaseTWinMessageSnatcher.TearDown;
begin
  inherited;
  snatcher_.Free;
end;

procedure TTestCaseTWinMessageSnatcher.TestOnFinalizeHWNDFired;
var
  form: TForm;
  receiver: THWNDEventReceiver;
begin
  receiver := THWNDEventReceiver.Create;
  form := TForm.Create(Application);
  try
    snatcher_.OnFinalizeHWND := receiver.HWNDEvent;
    snatcher_.WinControl := form;
    snatcher_.WinControl := Nil;
    Check(receiver.Received);
  finally
    form.Free;
    receiver.Free;
  end;
end;

procedure TTestCaseTWinMessageSnatcher.TestOnInitializeHWNDFired;
var
  form: TForm;
  receiver: THWNDEventReceiver;
begin
  receiver := THWNDEventReceiver.Create;
  form := TForm.Create(Application);
  try
    snatcher_.OnInitializeHWND := receiver.HWNDEvent;
    snatcher_.WinControl := form;
    Check(receiver.Received);
  finally
    form.Free;
    receiver.Free;
  end;
end;

initialization
  TestFramework.RegisterTest(TTestCaseTWinMessageSnatcher.Suite);
end.
 