unit TestCaseTMessageSnatcher;

// $Id: TestCaseTMessageSnatcher.pas,v 1.3 2002/04/10 17:08:27 takao Exp $

interface

uses
  Classes, Forms, TestFrameWork, MSGSnatchers;

type
  TTestCaseMessageSnatcher = class(TTestCase)
  private
    form_: TForm;
    snatcher1_: TMessageSnatcher;
    snatcher2_: TMessageSnatcher;
  protected
    procedure Setup; override;
    procedure TearDown; override;
  published
    procedure TestWindowProcModified;
    procedure TestWindowProcRestored;
    procedure TestChain;
    procedure TestInsertAfter;
  end;


implementation


function MethodEquals(aMethod1, aMethod2: TMethod): Boolean;
begin
  Result :=
    (aMethod1.Code = aMethod2.Code)
    and
    (aMethod1.Data = aMethod2.Data)
end;


{ TTestCaseMessageSnatcher }

procedure TTestCaseMessageSnatcher.Setup;
begin
  inherited;
  form_ := TForm.Create(Application);
  snatcher1_ := TMessageSnatcher.Create(form_);
  snatcher2_ := TMessageSnatcher.Create(form_);
end;

procedure TTestCaseMessageSnatcher.TearDown;
begin
  snatcher2_.Free;
  snatcher1_.Free;
  form_.Free;
  inherited;
end;

(*
TControl
	WndProc
	  |
	WindowProc


TControl		TMessageSnatcher1
	WndProc  ->    WndProc
	WindowProc <-  OldWndProc


TControl          TMessageSnatcher2     TMessageSnatcher1
	WndProc ------> WndProc
	WindowProc      OldWndProc ---------> WndProc
		^
		+-------------------------------- OldWndProc


TControl          TMessageSnatcher2
	WndProc         WndProc
       |
	WindowProc      OldWndProc ---------> ?

*)
procedure TTestCaseMessageSnatcher.TestChain;
var
  method: TWndMethod;
begin
  method := form_.WindowProc;
  snatcher1_.Control := form_;
  snatcher2_.Control := form_;
  snatcher1_.Control := Nil;
  snatcher2_.Control := Nil;
  Check(MethodEquals(TMethod(method), TMethod(form_.WindowProc)));
end;

procedure TTestCaseMessageSnatcher.TestInsertAfter;
var
  method: TWndMethod;
begin
  method := form_.WindowProc;
  snatcher1_.Control := form_;
  snatcher2_.InsertAfter(snatcher1_);
  snatcher1_.RemoveFromLink;
  Check(not MethodEquals(TMethod(method), TMethod(form_.WindowProc)));
end;

procedure TTestCaseMessageSnatcher.TestWindowProcModified;
var
  method: TWndMethod;
begin
  method := form_.WindowProc;
  snatcher1_.Control := form_;
  Check(not MethodEquals(TMethod(method), TMethod(form_.WindowProc)));
end;

procedure TTestCaseMessageSnatcher.TestWindowProcRestored;
var
  method: TWndMethod;
begin
  method := form_.WindowProc;
  snatcher1_.Control := form_;
  snatcher1_.Control := Nil;
  Check(MethodEquals(TMethod(method), TMethod(form_.WindowProc)));
end;

initialization
  TestFramework.RegisterTest(TTestCaseMessageSnatcher.Suite);
end.

