/*
 * Decompiled with CFR 0.152.
 */
package okuyama.base.util;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import okuyama.base.job.AbstractHelper;
import okuyama.base.lang.BatchException;
import okuyama.base.parameter.config.HelperConfigMap;
import okuyama.base.util.ClassUtility;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;

public class HelperPool
extends Thread {
    private static ILogger logger = LoggerFactory.createLogger(HelperPool.class);
    private static CopyOnWriteArrayList helperNameList = new CopyOnWriteArrayList();
    private static ConcurrentHashMap configMap = new ConcurrentHashMap(1024, 1000.0f, 512);
    private static ConcurrentHashMap helperMap = new ConcurrentHashMap(1024, 1000.0f, 512);
    private static ConcurrentHashMap helperReturnParamMap = new ConcurrentHashMap(1024, 1000.0f, 512);
    private static ConcurrentHashMap helperStatusMap = new ConcurrentHashMap(8192, 1000.0f, 512);
    private static ConcurrentHashMap executorServiceMap = new ConcurrentHashMap(1024, 1000.0f, 512);
    private static ConcurrentHashMap serviceParameterQueueMap = new ConcurrentHashMap(1024, 1000.0f, 512);
    private static CopyOnWriteArrayList allExecuteHelperList = new CopyOnWriteArrayList();
    private static int helperCheckTime = 2500;
    private static int helperThreadJoinTime = 5000;
    private boolean poolRunning = true;
    private static ArrayBlockingQueue helperParamQueue = new ArrayBlockingQueue(1000);

    @Override
    public void run() {
        logger.debug("HelperPool - run - start");
        try {
            while (this.poolRunning) {
                Thread.sleep(helperCheckTime);
                int size = allExecuteHelperList.size();
                for (int i = 0; i < size; ++i) {
                    AbstractHelper helper = (AbstractHelper)allExecuteHelperList.get(size - 1 - i);
                    if (!helper.getThreadEnd()) continue;
                    HelperPool.cleanEndHelper(helper.hashCode());
                    allExecuteHelperList.remove(size - 1 - i);
                    if (helper.getReboot()) {
                        logger.debug("Helper[" + helper.getName() + " Reboot Start");
                        AbstractHelper newHelper = HelperPool.getHelper(helper.getName());
                        newHelper.setParameters(helper.getParameters());
                        newHelper.setReboot(true);
                        HelperPool.returnHelper(newHelper.getName(), newHelper);
                        allExecuteHelperList.add(newHelper);
                        logger.debug("Helper[" + helper.getName() + " Reboot Success");
                    }
                    ((ThreadPoolExecutor)executorServiceMap.get(helper.getName())).remove(helper);
                }
            }
            logger.debug("HelperPool - End Process Start");
            for (int i = 0; i < helperNameList.size(); ++i) {
                ((ThreadPoolExecutor)executorServiceMap.get((String)helperNameList.get(i))).shutdown();
            }
            logger.debug("HelperPool - End Process End");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("HelperPool - run - Error", e);
        }
    }

    public static void initializeHelperPool() {
        helperNameList = new CopyOnWriteArrayList();
        configMap = new ConcurrentHashMap(1024, 1000.0f, 512);
        helperMap = new ConcurrentHashMap(1024, 1000.0f, 512);
        helperReturnParamMap = new ConcurrentHashMap(1024, 1000.0f, 512);
        helperStatusMap = new ConcurrentHashMap(1024, 1000.0f, 512);
        serviceParameterQueueMap = new ConcurrentHashMap(1024, 1000.0f, 512);
    }

    public static AbstractHelper getHelper(String helperName) throws BatchException {
        logger.debug("HelperPool - getHelper - start");
        AbstractHelper helper = null;
        Object useCount = null;
        Object helperList = null;
        try {
            if (!helperMap.containsKey(helperName)) {
                throw new BatchException("Helper [" + helperName + "] Not Found");
            }
            HelperConfigMap helperConfigMap = (HelperConfigMap)configMap.get(helperName);
            helper = ClassUtility.createHelperInstance(helperConfigMap.getHelperClassName());
            helper.setName(helperName);
            helper.setConfig(helperConfigMap);
            helper.initialize();
            helperStatusMap.put(new Integer(helper.hashCode()), helper.getStatus());
        }
        catch (Exception e) {
            logger.error("HelperPool - getHelper - BatchException");
            throw new BatchException(e);
        }
        logger.debug("HelperPool - getHelper - end");
        return helper;
    }

    public static void returnHelper(String helperName, AbstractHelper helper) throws BatchException {
        try {
            ((ThreadPoolExecutor)executorServiceMap.get(helperName)).execute(helper);
            allExecuteHelperList.add(helper);
        }
        catch (Exception be) {
            logger.error("HelperPool - returnHelper - BatchException");
            throw new BatchException(be);
        }
    }

    public static int getActiveHelperInstanceCount(String helperName) {
        return ((ThreadPoolExecutor)executorServiceMap.get(helperName)).getActiveCount();
    }

    public static void managedHelperConfig(HelperConfigMap helperConfigMap) throws BatchException {
        helperNameList.add(helperConfigMap.getHelperName());
        configMap.put(helperConfigMap.getHelperName(), helperConfigMap);
        helperMap.put(helperConfigMap.getHelperName(), new ArrayList());
        executorServiceMap.put(helperConfigMap.getHelperName(), Executors.newCachedThreadPool());
        serviceParameterQueueMap.put(helperConfigMap.getHelperName(), new ArrayBlockingQueue(20000));
    }

    public static void createUniqueHelperParamQueue(String uniqueQueueName, int size) {
        serviceParameterQueueMap.put(uniqueQueueName, new ArrayBlockingQueue(size));
    }

    public static int getParameterQueueSize(String queueName) throws Exception {
        int ret = -1;
        try {
            ret = ((ArrayBlockingQueue)serviceParameterQueueMap.get(queueName)).size();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return ret;
    }

    public static void addParameterQueue(Object[] params) throws Exception {
        try {
            helperParamQueue.put(params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void addSpecificationParameterQueue(String helperName, Object[] params) throws Exception {
        try {
            HelperPool.addSpecificationParameterQueue(helperName, params, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void addSpecificationParameterQueue(String helperName, Object[] params, boolean debug) throws Exception {
        try {
            ((ArrayBlockingQueue)serviceParameterQueueMap.get(helperName)).put(params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static Object[] pollParameterQueue() {
        Object[] ret = null;
        try {
            ret = (Object[])helperParamQueue.take();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Object[] pollSpecificationParameterQueue(String helperName) {
        Object[] ret = null;
        try {
            ret = (Object[])((ArrayBlockingQueue)serviceParameterQueueMap.get(helperName)).take();
        }
        catch (Exception e) {
            logger.error("pollSpecificationParameterQueue - ERROR [" + helperName + "]");
            logger.error(serviceParameterQueueMap);
            e.printStackTrace();
        }
        return ret;
    }

    public static Object getReturnParam(int helperHashCode) {
        Object ret = null;
        if (helperReturnParamMap.containsKey(new Integer(helperHashCode))) {
            ret = helperReturnParamMap.get(new Integer(helperHashCode));
        }
        return ret;
    }

    public static void cleanEndHelper(int helperHashCode) {
        if (helperStatusMap.containsKey(new Integer(helperHashCode))) {
            helperStatusMap.put(new Integer(helperHashCode), "job_end");
        }
        if (helperReturnParamMap.containsKey(new Integer(helperHashCode))) {
            helperReturnParamMap.remove(new Integer(helperHashCode));
        }
    }

    public static String getHelperStatus(int helperHashCode) {
        String ret = null;
        if (helperStatusMap.containsKey(new Integer(helperHashCode))) {
            ret = (String)helperStatusMap.get(new Integer(helperHashCode));
        }
        return ret;
    }

    public void poolEnd() {
        this.poolRunning = false;
    }
}

