/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import okuyama.imdst.util.CoreMapKey;
import okuyama.imdst.util.FileBaseDataMap;
import okuyama.imdst.util.ImdstDefine;

public class PartialConcurrentHashMap
extends ConcurrentHashMap
implements Cloneable,
Serializable {
    private boolean fullMemory = true;
    private FileBaseDataMap bigValueStoreMap = null;
    static byte[] flg = new byte[1];

    public PartialConcurrentHashMap(int size, int upper, int multi, String[] bigValueStoreDirs) {
        super(size, upper, multi);
        if (ImdstDefine.bigValueFileStoreUse && bigValueStoreDirs != null) {
            this.fullMemory = false;
            String[] bigValueStoreDir = new String[]{bigValueStoreDirs[0] + "/partialbigdata1/", bigValueStoreDirs[0] + "/partialbigdata2/", bigValueStoreDirs[0] + "/partialbigdata3/", bigValueStoreDirs[0] + "/partialbigdata4/", bigValueStoreDirs[0] + "/partialbigdata5/"};
            this.bigValueStoreMap = new FileBaseDataMap(bigValueStoreDir, 100000, 0.01, ImdstDefine.saveDataMaxSize, ImdstDefine.memoryStoreLimitSize * 2, ImdstDefine.memoryStoreLimitSize * 6);
        }
    }

    @Override
    public Object put(Object key, Object value) {
        byte[] valueBytes = (byte[])value;
        if (!this.fullMemory && valueBytes.length > ImdstDefine.memoryStoreLimitSize) {
            this.bigValueStoreMap.put(new String(((CoreMapKey)key).getDatas()), new String(BASE64EncoderStream.encode((byte[])valueBytes)));
            super.put(key, flg);
        } else {
            super.put(key, valueBytes);
        }
        return null;
    }

    @Override
    public Object get(Object key) {
        Object ret = super.get(key);
        if (ret == null || this.fullMemory || ((byte[])ret).length > 1) {
            return ret;
        }
        String valueStr = (String)this.bigValueStoreMap.get(new String(((CoreMapKey)key).getDatas()));
        if (valueStr == null) {
            return null;
        }
        byte[] retBytes = valueStr.getBytes();
        return BASE64DecoderStream.decode((byte[])retBytes);
    }

    @Override
    public Object remove(Object key) {
        Object ret = super.remove(key);
        if (ret == null || this.fullMemory || ((byte[])ret).length > 1) {
            return ret;
        }
        String valueStr = (String)this.bigValueStoreMap.remove(new String(((CoreMapKey)key).getDatas()));
        if (valueStr == null) {
            return null;
        }
        byte[] retBytes = valueStr.getBytes();
        return BASE64DecoderStream.decode((byte[])retBytes);
    }
}

