/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.ArrayBlockingQueue;
import okuyama.imdst.util.KeyMapManager;
import okuyama.imdst.util.SystemUtil;

class DataTransactionFileFlushDaemon
extends Thread {
    private volatile ArrayBlockingQueue delayWriteQueue = new ArrayBlockingQueue(4096);
    public volatile boolean execFlg = true;
    public volatile String tFilePath = null;
    public volatile BufferedWriter tBw = null;
    public volatile boolean executeEnd = false;

    DataTransactionFileFlushDaemon() {
    }

    @Override
    public void run() {
        boolean writeCount = false;
        String writeStr = null;
        int bufferUseCount = 0;
        int maxBufferUseCount = 1000000;
        while (this.execFlg) {
            try {
                if (writeStr == null) {
                    writeStr = (String)this.delayWriteQueue.take();
                }
                if (this.tBw == null) continue;
                this.tBw.write(writeStr);
                SystemUtil.diskAccessSync(this.tBw);
                writeStr = null;
                if (++bufferUseCount <= maxBufferUseCount) continue;
                this.tBw.flush();
                this.tBw.close();
                this.tBw = null;
                this.tBw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.tFilePath)), KeyMapManager.workMapFileEnc), 196608);
            }
            catch (Throwable te) {
                te.printStackTrace();
            }
        }
        this.executeEnd = true;
    }

    public ArrayBlockingQueue getDataTransactionFileQueue() {
        return this.delayWriteQueue;
    }

    public void setDataTransactionFileQueue(ArrayBlockingQueue queue) {
        this.delayWriteQueue = queue;
    }

    public boolean getExecuteEnd() {
        return this.executeEnd;
    }

    public void addDataTransaction(String str) {
        while (true) {
            try {
                this.delayWriteQueue.put(str);
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.tBw != null) {
            try {
                SystemUtil.diskAccessSync(this.tBw);
            }
            catch (Throwable te) {
            }
            finally {
                try {
                    this.tBw.close();
                }
                catch (Throwable te2) {}
                this.tBw = null;
                this.tFilePath = null;
            }
        }
    }
}

