/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "commontypes.h"

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	namespace NS_DataStorage
	{
		class IDataStorage;
	}
}

namespace NS_DM_Client
{
    extern const char* S_seperator;
    extern const char* S_rootNode;
    extern const char* S_interiorNodeFormat;
	extern const char* S_interiorNodeDefType;
	extern const char* S_leafNodeDefType;
	extern const char* S_leafNodeDefFormat;
    extern const char* S_permanentFile;

	extern const char* S_propertyName[];

	enum Property
	{
		e_ACL,
		e_format,
		e_name,
		e_size,
		e_title,
		e_tstamp,
		e_type,
		e_verNo
	};

	class Node
	{
	public:
		Node(const URI& path, NS_DM_Client::NS_DataStorage::IDataStorage* dataStorage);
		~Node();

		void SetContent(const String& content);
		bool GetContent(String& content) const;

		void SetProperty(Property name, const String& value);
		bool GetProperty(Property name, String& content) const;

        Node* GetParent() const;
        Node* GetExistingParent() const;

        bool IsPermanent() const;
        void SetPermanent();

		bool IsLeaf() const;
		bool Exist() const;
		bool Delete();

		typedef std::vector<URI> ChildrenPaths;
		bool GetChildren(ChildrenPaths& children) const;
		const URI& GetPath() const { return m_path; }
		const URI GetName() const;
		bool GetContentSize(size_t& size) const;

	private:
		void copyFromBuffer(String& destination, void* source, size_t size) const;

	private:
		String m_path;
		NS_DM_Client::NS_DataStorage::IDataStorage* m_dataStorage;
		NS_Logging::Logger& m_logger;
	};

	bool GetPropertyByName(const String& name, Property& property);
	bool IsPropertyReplacementSupported(Property property);
    void ParseNodePath(const URI& full_name, String& path_name, String& node_name);
    Node* GetExistingParentWithACL(const Node* node);
	String IntToString(int value);
}
