/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <base/util/Enumeration.h>
#include <syncml/formatter/Formatter.h>
#include "serverexchange/wrappers/SResultsCommand.h"
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "SResultsCommand";

using namespace NS_DM_Client::NS_SyncMLCommand;


SResultsCommand::SResultsCommand()
{
}


SResultsCommand::~SResultsCommand()
{
}


void SResultsCommand::createItemizedCommand()
{
    Funambol::Results *pResults = new Funambol::Results();
    if(pResults == NULL) GDLWARN("new Funambol::Results");

    m_ptrItemizedCommand.reset(pResults);

    pResults->setMsgRef(GetMsgRef());
    pResults->setCmdRef(GetCmdRef());

    Funambol::Enumeration &e = m_mapResults.getProperties();
    Funambol::ArrayList results; // list with Funambol::Item* instances
    while (e.hasMoreElement())
    {
        Funambol::ArrayElement* el = e.getNextElement();
        Funambol::KeyValuePair *pair = static_cast<Funambol::KeyValuePair*>(el);

        if (pair && pair->getKey().c_str())
        {
            Funambol::Source source(pair->getKey().c_str());
            Funambol::ComplexData data(pair->getValue().c_str());
            Funambol::Item item(NULL/*target*/, &source, NULL/*meta*/, &data, false);

            // fill Meta info for the item
            Funambol::Meta meta;
            Funambol::StringBuffer format = m_mapFormats.readPropertyValue(pair->getKey());
            if (format.c_str() != NULL && format.length())
            {
                meta.setFormat(format.c_str());
            }

            Funambol::StringBuffer type = m_mapTypes.readPropertyValue(pair->getKey());
            if (type.c_str() != NULL && type.length())
            {
                meta.setType(type.c_str());
            }

            if (format.length() || type.length())
                item.setMeta(&meta);

            results.add(item);
        }
    }

    if (results.size())
        pResults->setItems(&results);
}


void SResultsCommand::AddResult(const char *key, const char * value)
{
    AddResult(key, value, NULL, NULL);
}


void SResultsCommand::AddResult(const char *key, const char * value, const char *format, const char *type)
{
    if (key)
    {
        if (value)
            m_mapResults.setPropertyValue(key, value);
        else
            m_mapResults.setPropertyValue(key, "");

        if (format)
            m_mapFormats.setPropertyValue(key, format);

        if (type)
            m_mapTypes.setPropertyValue(key, type);
    }
}


Funambol::Results * SResultsCommand::GetResults()
{
    return this_results();
}


Funambol::StringBuffer * SResultsCommand::ToString()
{
    if (m_ptrItemizedCommand.get())
        return Funambol::Formatter::getResults(this_results());
    else
        return SCommandAdapter::ToString();
}

