/*
 *  UT_Utils.cpp
 *  OMA-DM Client
 *
 *  Created by Mykola Bilovus on 20/04/10.
 *  Copyright 2010. All rights reserved.
 *
 */


#include <boost/test/unit_test.hpp>
#include "serverexchange/session/SessionsFactory.h"


using namespace NS_DM_Client::NS_Communication;


BOOST_AUTO_TEST_SUITE(SuiteSEM)


BOOST_AUTO_TEST_CASE(TestCase_SessionsFactory_CreateSession)
{
	ConnectionInfo info;
	ISession *pSession;

	info.acconfig.setClientAuthType(AUTH_TYPE_BASIC);
	pSession = SessionsFactory::Instance().CreateSession(info);
	BOOST_CHECK(pSession);
	delete pSession;
	
	info.acconfig.setClientAuthType(AUTH_TYPE_MD5);
	pSession = SessionsFactory::Instance().CreateSession(info);
	BOOST_CHECK(pSession);
	delete pSession;
	
	info.acconfig.setClientAuthType(AUTH_TYPE_MAC);
	pSession = SessionsFactory::Instance().CreateSession(info);
	BOOST_CHECK(pSession);
	delete pSession;
}


BOOST_AUTO_TEST_CASE(TestCase_SessionsFactory_SetCreator)
{
	TransportCreator creator;
	SessionsFactory::Instance().SetTransportCreator(creator);
}


BOOST_AUTO_TEST_SUITE_END()

