#include "DaemonEngineRequest.h"
#include "Logger/Logger.h"
#include "serverexchange/commands/RequestFWUCommand.h"
#include "executionqueue/IExecutionQueue.h"

namespace NS_DM_Client
{
    DaemonEngineRequest::DaemonEngineRequest(ProfileComponentsHolder& m_componentHolder): m_componentHolder(m_componentHolder),
        m_logger(NS_Logging::GetLogger("DaemonEngineRequest"))
    {

    }
    //-------------------------------------------------------------------------------------------

    void DaemonEngineRequest::CheckFUMOUpdate()
    {
        LOG_(m_logger, "Received \"CheckFUMOUpdate\" request");

        NS_Communication::RequestFWUCommand* command = new(std::nothrow) NS_Communication::RequestFWUCommand(*m_componentHolder.GetServerExchangeManager(), false);
        if (command != (NS_Communication::RequestFWUCommand*)NULL)
        {
            LOG_ERROR_(m_logger, "Failed to create RequestFWUCommand");
            return;
        }
        LOG_(m_logger, "RequestFWUCommand is created");

        bool res = m_componentHolder.GetExecutionQueue()->Add(*command);
        if (res)
        {
            LOG_(m_logger, "RequestFWUCommand is added to execution queue");
        }
        else
        {
            LOG_ERROR_(m_logger, "Failed to add RequestFWUCommand to queue");
            delete command;
        }
    }

    void DaemonEngineRequest::DeviceStatusChanged(EnumDeviceStatus newStatus)
    {
        LOG_(m_logger, "Enter");
    }

    void DaemonEngineRequest::NetworkStatusChanged(EnumNetworkStatus newStatus)
    {
        LOG_(m_logger, "Enter");
    }
}
