/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "DaemonDM/IPCDaemonEngine.h"

#include "daemon/IDaemonEngine.h"
#include "commontypes.h"
#include "IFIFOWrapper.h"
#include "MessengerDefs.h"
#include "Logger/Logger.h"

#include "common/platform.h"


namespace NS_DM_Client
{

//------------------------------------------------------------------------------------------------------
IPCDaemonEngine::IPCDaemonEngine()
{
}
//------------------------------------------------------------------------------------------------------
IPCDaemonEngine::~IPCDaemonEngine()
{
}
//------------------------------------------------------------------------------------------------------
IPCDaemonEngine::IPCDaemonEngine(const IPCDaemonEngine&)
{
    #ifndef PLATFORM_ANDROID
        throw "error: trying to call copy constructor for IPCDaemonEngine";
    #else
        NULL;
    #endif
}
//------------------------------------------------------------------------------------------------------
IPCDaemonEngine& IPCDaemonEngine::operator=(const IPCDaemonEngine&)
{
    #ifndef PLATFORM_ANDROID
        throw "error: trying to call operator= for IPCDaemonEngine";
    #else
        NULL;
    #endif

    return *this;
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonEngine::Init(IDaemonEngine* daemonEngine)
{
LOG_INFO_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "Enter");

    m_engine = daemonEngine;
    m_actionThread.Init(this);

LOG_INFO_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "Exit");
    return true;
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonEngine::Start()
{
LOG_INFO_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "Enter");
    if (m_actionThread.running())
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "%s", "IPC Daemon engine already started");
        return true;
    }
    m_actionThread.start();
LOG_INFO_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "Exit");
    return true;
}
//------------------------------------------------------------------------------------------------------
IDaemonEngine* IPCDaemonEngine::GetDaemonEngine()
{
    return m_engine;
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonEngine::Stop()
{
LOG_INFO_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "Enter");
    if (!m_actionThread.running())
    {
        LOG_WARNING_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "%s", "IPC Daemon Engine not started. No need stop");
        return true;
    }

    IFIFOWrapper *fifo_stop_request, *fifo_stop_responce;
    if (!initializeIPCFifos(fifo_stop_request, fifo_stop_responce, true))
    {
        return false;
    }
    Buffer stop_request(sizeof(UIExchangeHead), '\0');
    memcpy(stop_request.GetPointer(), c_StopRequest, strlen(c_StopRequest)); // "stop\0" alvays smaller then sizeof(UIExchangeHead)
    if (fifo_stop_request->Write(stop_request) == e_Ok)
    {
        m_actionThread.wait();
    }
    else
    {
        releaseFifos(fifo_stop_request, fifo_stop_responce);
        return false;
    }
    releaseFifos(fifo_stop_request, fifo_stop_responce);
LOG_INFO_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "Exit");
    return true;
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonEngine::Release()
{
    delete this;
    return true;
}
//------------------------------------------------------------------------------------------------------
IPCDaemonEngine* CreateDaemonIPCEngine(IDaemonEngine* daemon_engine)
{
LOG_INFO_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "Enter");

    if (daemon_engine != (IDaemonEngine*)NULL)
    {
        LOG_INFO_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "Deamon is already existed");
        return (IPCDaemonEngine*)NULL;
    }

    IPCDaemonEngine* res = new(std::nothrow) IPCDaemonEngine();
    if (res != (IPCDaemonEngine*)NULL)
    {
        if (!res->Init(daemon_engine))
        {
            res->Release();
            res = (IPCDaemonEngine*)NULL;
        }
    }

LOG_INFO_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "Exit");
    return res;
}
//------------------------------------------------------------------------------------------------------
}
