/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "ClientAdapter/INotificationUpdater.h"
#include "common/Event.h"

namespace NS_DM_Client
{
	class NotificationUpdaterImpl: public INotificationUpdater
	{
	public:
		NotificationUpdaterImpl(void* context, size_t stop = 1): INotificationUpdater(context), m_sessionStarted(false),
			m_notifyDMSession(false), m_firmwareUpdated(false), 
			m_event(reinterpret_cast<NS_Common::EventEx*>(context)), m_stopAfterN(stop), m_notifyProvisionUpdated(false)
		{} 
		virtual ~NotificationUpdaterImpl() {};

		virtual void DMSessionNotif(EventType eventType, Initiator initiator, NotificationStatus statusCode) 
		{
			printf("Received notification for DMSessionNotif. Event = %d, Initiator = %d, StatusCode = %d", eventType,
				initiator, statusCode);
		}

		virtual void FirmwareInfo(const String &localpath, const String &filename, const int size) {}
		virtual void FirmwareUpdateStart(FirmwareUpdate::EnumFirmwareOperation fwo) {}
		virtual void FirmwareUpdateFinished(FirmwareUpdate::EnumFirmwareOperation fwo) {}

		virtual void SessionStarted(bool isSuccessful) {}
		virtual void SessionAborted() {}
		virtual void SessionFinished() {}
		virtual void StartDMSessionStatus(bool sessionStarted)
		{
			m_sessionStarted = sessionStarted;
			printf("Received notification for StartDMSessionStatus. sessionStarted = %d", m_sessionStarted);
			if (--m_stopAfterN == 0)
			{
				m_event->signal();
			}
		}
		//-------------------------------------------------------------------------------------------

		virtual void DMSessionNotif(NotificationStatus status)
		{
			m_notifyDMSession = true;
			printf("Received notification for DMSessionNotif. sessionStarted = %d", m_notifyDMSession);
			if (--m_stopAfterN == 0)
			{
				m_event->signal();
			}
		}

		virtual void CheckFirmwareUpdateStatus(bool firmwareUpdated)
		{
			m_firmwareUpdated = firmwareUpdated;
			printf("Received notification for CheckFirmwareUpdateStatus. firmwareUpdated = %d", m_firmwareUpdated);
			if (--m_stopAfterN == 0)
			{
				m_event->signal();
			}
		}

		virtual void FirmwareUpdateNotif(EnumFirmwareOperation fwo, NotificationStatus status)
		{
			printf("Received notification for FirmwareUpdateNotify. Operation = %d,  status = %d", fwo, status);
			m_event->signal();
		}

		void StartDRMDCollecting(int duration)
		{

		}

		void ProvisioningUpdate(const StringArray& URIs, CommandType command, EventType eventType, StatusCode resultCode)
		{
			printf("Received notification for ProvisioningUpdate. URI = %s, commandType = %d,  EventType = %d, resultCode = %d", 
				URIs[0].c_str(), command, eventType, resultCode);
			m_notifyProvisionUpdated = true;
			m_event->signal();
		}

	public:
		bool m_sessionStarted;
		bool m_notifyDMSession;
		bool m_firmwareUpdated;
		bool m_notifyProvisionUpdated;

		NS_Common::EventEx* m_event;

		int m_stopAfterN;
	};
}
