#include "MockConfiguration.h"
#include "Logger.h"
#include "daemon/Profile.h"

namespace NS_DM_Client
{
using namespace NS_Daemon;

	MockConfiguration::MockConfiguration(): NS_Daemon::Configuration(NS_Logging::GetLogger("Mock"))
	{

	}
	//-------------------------------------------------------------------------------------------

	void MockConfiguration::AddProfile(NS_Daemon::Profile* profile)
	{
		m_profiles.push_back(profile);
	}
	//-------------------------------------------------------------------------------------------

	int MockConfiguration::GetProfilesCount() const
	{
		return m_profiles.size();
	}
	//-------------------------------------------------------------------------------------------

	Profile* MockConfiguration::GetProfile(int i)
	{
		if (m_profiles.size() <= (size_t)i)
			return 0;

		return m_profiles[i];
	}
	//-------------------------------------------------------------------------------------------

	Profile* MockConfiguration::GetProfile(const String& profileName)
	{
		for (Profiles::iterator iter(m_profiles.begin()); iter != m_profiles.end(); ++iter)
		{
			Profile* profile = *iter;
			if (profile->GetName() == profileName)
				return profile;
		}
		return 0;
	}
}