/*
 * Copyright 2010 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "treemanager/IMOTreeManager.h"

namespace NS_DM_Client
{
	#define URI_DMACC        "./DMAcc"
	extern const String s_URI_DMACC;  // uri "./DMAcc" is assigned

	namespace TMUtils
	{
		/*
		 * Check whether account with passed server id is present in the MO tree
		 */
		bool HasAccount(IMOTreeManager &, String &serverID);

		/*
		 * Get server id of the first available account
		 */
		void GetFirstAccount(IMOTreeManager &, String &serverID);

		/*
		 * Get value of the node with uri "uriNode/leafname"
		 */
		bool GetChildNodeValue(IMOTreeManager &, const String& uriNode, const char* leafname, String& result);

		/*
		 * Check whether passed uri represents dm account node
		 */
		bool IsDMAccNode(IMOTreeManager &, const char *uri);
	}
}