/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <base/util/MemoryKeyValueStore.h>
#include <syncml/core/Results.h>
#include "serverexchange/wrappers/SResponseCommand.h"


namespace NS_DM_Client
{
	namespace NS_SyncMLCommand
	{
		typedef boost::shared_ptr<class SResultsCommand> SResultsCommandPtr;

		class SResultsCommand : public NS_SyncMLCommand::SResponseCommand
		{
		public:
			SResultsCommand();
			virtual ~SResultsCommand();

			void AddResult(const char *key, const char * value);
			void AddResult(const char *key, const char * value,  const char *format, const char *type);

			Funambol::Results *GetResults();
			/// Get xml representation of the command
			virtual Funambol::StringBuffer * ToString();

		protected:
			virtual void createItemizedCommand();

			inline Funambol::Results *this_results()
			{
				return static_cast<Funambol::Results*>(m_ptrItemizedCommand.get());
			}

		private:
			class StringMap : public Funambol::MemoryKeyValueStore
			{
			public:
				StringMap() {}
				virtual ~StringMap() {}
				virtual int close() { return 0; }
			};

			StringMap m_mapResults;
			StringMap m_mapFormats;
			StringMap m_mapTypes;
		};
	}
}
