/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <syncml/core/Alert.h>
#include "serverexchange/wrappers/SCommandAdapter.h"
#include "serverexchange/commands/AlertCodes.h"

namespace NS_DM_Client
{
	namespace NS_SyncMLCommand
	{
		typedef boost::shared_ptr<class SAlertCommand> SAlertCommandPtr;

		class SAlertCommand : public NS_SyncMLCommand::SCommandAdapter
		{
		public:
			SAlertCommand();
			SAlertCommand(int data);
			virtual ~SAlertCommand();

			Funambol::Alert *GetAlert();
			int  GetData();
			void SetData(int data);
			void AddItem(Funambol::Item &item);
			virtual Funambol::StringBuffer * ToString();

		protected:
			virtual void createItemizedCommand();

		private:
			int m_data;

			inline Funambol::Alert *this_alert()
			{
				return static_cast<Funambol::Alert*>(m_ptrItemizedCommand.get());
			}
		};
	}
}
