/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "treemanager/MOTreeCommand.h"
#include "daemon/ProfileComponentsHolder.h"

namespace NS_DM_Client
{
    class TriggerDRMDCollectingCommand : public MOTreeCommand
    {
    public:
		/**
		 * Command starts diagnostics collection.
		 * Command will fail if duration value is 0, 3 or 4
		 */
        TriggerDRMDCollectingCommand(ProfileComponentsHolder*, int duration);

		/**
		 * Command starts diagnostics collection.
		 * Duration value is read from the tree. 
		 * Command will fail if value is not in the mo tree or is 0, 3 or 4
		 */
        TriggerDRMDCollectingCommand(ProfileComponentsHolder* prholder);

		virtual bool Execute();
		
    protected:
		ProfileComponentsHolder* m_pch;
		int m_duration;
		bool m_readDuration;

		virtual bool requestData(int duration);
    };
}
