/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "treemanager/MOTreeCommand.h"
#include "daemon/ProfileComponentsHolder.h"

namespace NS_DM_Client
{
	class AdjustFUMOStatus : public MOTreeCommand
	{
	public:
		AdjustFUMOStatus(ProfileComponentsHolder *pHolder, String uriDiagnosticsDuration, uint value);
		virtual ~AdjustFUMOStatus();
		virtual bool Execute();
		
	private:
		ProfileComponentsHolder *m_pProfileHolder;
		String m_uriFUMO;
		uint m_value;
		
		AdjustFUMOStatus(const AdjustFUMOStatus &);
		AdjustFUMOStatus & operator=(const AdjustFUMOStatus &);
	};
}
