/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <syncml/core/ItemizedCommand.h>
#include <DaemonDM/Messenger.h>
#include "serverexchange/wrappers/SCommandAdapter.h"

namespace NS_DM_Client
{
    namespace NS_Communication
    {
        class LOCollector
        {
        public:
			LOCollector();
			virtual ~LOCollector();

			int  AddChunk(Funambol::ItemizedCommand &pCommand);
			ItemizedCommandPtr GetResultCmd();
			bool IsCompleted();
			const char *GetLOCmdName();
			const char *GetLOTargetURI();

		private:
			ItemizedCommandPtr m_command;
			int   m_expected_size;
			char *m_targeturi;
			char *m_buffer;
			int   m_buffersize;
			int   m_bufferpos;
			NS_DM_Client::Messenger *m_pMessenger;
			bool  notifyProgress();
        };
    }
}

