/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "CritSection.h"

namespace NS_DM_Client
{
	namespace NS_Common
	{
		/// Automatically lock/unlock mutex on create/destroy object.
		class Lock
		{
		public:

			/// Lock passed mutex
			Lock(CritSection &cs) : m_critsection(cs)
			{
				m_critsection.Lock();
			}

			/// Unlock mutex passed into constructor
			~Lock()
			{
				m_critsection.Unlock();
			}

		private:
			CritSection &m_critsection;
		};
	}
}
