/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

namespace NS_DM_Client
{
    namespace NS_Common
    {
		/**
		 * Calculate HMAC cred
		 * H( B64(H(username:password)):nonce:B64(H(message body)) )
		 * function returns Base64 encoding of HMAC
		 * Returned string must be freed by the caller
		 */
		const char * calculateHMAC(const char *username, const char *password, const char *b64nonce, const char *msg, int msg_len);
		
		
		/**
		 * Calculate credentials with DRMD specific algorithm
		 * f = B64(MD5-hash(abS))
		 * Returned string must be freed by the caller
		 */
		const char * calculateF(const char *a, const char *b, const char *S);
    }
}

