/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */
#pragma once

#include "commontypes.h"


/**
 * Class reads pairs key,value from the properties file
 * Format of properties file must be:
 * property_name = value (blankspace before '=' is mundatory)
 */
namespace NS_Common
{
	class PropertiesReader
	{
	public:
		typedef struct _property {
			String name;
			String value;
			_property(const char *n, const char *v) : name(n), value(v) {}
		} Property;
		
		typedef std::vector<Property> Properties;
		
		PropertiesReader(const char *);
		PropertiesReader(String &filepath);
		
		const Properties::iterator begin();
		const Properties::iterator end();

		size_t size() const;

	private:
		String m_filepath;
		Properties m_properties;
		
		void read();
	};
}
