/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

namespace NS_DM_Client
{
	namespace NS_Common
	{
		class IOutStream
		{
		public:
			virtual ~IOutStream() {};
			virtual void Open(const char* ident) = 0;
			virtual void Write(const char* buffer, int size) = 0;
			virtual void Close() = 0;
			
			virtual int FormatMessage(char* buffer, int size, 
									  int threadID, const char* loggerName, 
									  const char* category, const char* functionName) = 0;
			
			virtual int FormatMessage(char* buffer, int size, 
									  int threadID, const char* loggerName, 
									  const char* category) = 0;
		};
	}
}
