/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <NotificationListener/WSPDefs.h>
#include <commontypes.h>

namespace NS_DM_Client
{
    namespace NS_NotificationListener
    {
        class WSPPushDecoder
        {
        public:
            WSPPushDecoder();

            bool    SetPDU(const void* PDU, size_t size, bool connectionless);

            /// get MIME type of Well-Known Content type
            NS_WSP::EnumContentTypes    GetWNContentType_MIMEType() const;

			/// get MIME type of Not-Known (variable length) Content type ref 
            const char*    GetNotWNContentTypeRef() const;

            bool    GetDataInfo(int& offsetFromPDUStart, int& size) const;

        private:
            WSPPushDecoder(const WSPPushDecoder&);
            WSPPushDecoder& operator = (const WSPPushDecoder&);

        protected:
			const char*    getContentTypeRef() const;

			static unsigned int     S_parseUintVar(const char* buf, int* varLen = NULL);

            static bool         S_get7bitValue(char& val);
            static int          S_parseMultipleOctetsLengthVar(const char* buf_ptr, const char*& skipLenVarPtr);

        private:
            buffer_t    m_pdu;
            bool        m_connectionless;
        };

    }

}

