/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

namespace NS_DM_Client
{
    namespace NS_WSP
    {
        /// PDU Types
        enum EnumPDUTypes
        {
            e_Reserved          = 0,

            e_Connect,
            e_ConnectReply,
            e_Redirect,
            e_Reply,
            e_Disconnect,
            e_Push,
            e_ConfirmedPush,
            e_Suspend,
            e_Resume,

            e_Get               = 0x40,
            e_GetOptions,
            e_GetHead,
            e_GetDelete,
            e_GetTrace,

            e_Post              = 0x60,
            e_PostPut,

            e_DataFragmentPDU   = 0x80

        };


        enum EnumContentTypes
        {
            e_Undefined     = -1,

            /// Well-Known Content Types

            // application/vnd.syncml.dm+wbxml
            e_application_vnd_syncml_dm_wbxml   = 0x42,

            // application/vnd.syncml.dm+xml
            e_application_vnd_syncml_dm_xml     = 0x43,

            // application/vnd.syncml.notification
            e_application_vnd_syncml_notification     = 0x44,

            e_CT_NotWellKnown  = 0x80,

            ///  application/vnd.wmf.bootstrap - The purpose of this Content Type number
            /// is to be use in with in WiMAX Forum Over-the-Air Provision bootstrap specification.
            e_application_vnd_wmf_bootstrap     = 0x0318

        };



        /// Well-Known Parameters
        enum EnumParameters
        {
            e_SEC       = 0x11,
            e_MAC       = 0x12
        };

    }

}


