/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include <commontypes.h>

namespace NS_DM_Client
{
	class IMOTreeManager;

	class TNDSExtractor
	{
	public:
		TNDSExtractor(const String& xml);
		void GetValue(const String& name, String& value);
		void GetValue(const String& name, bool& value); ////
		void GetValue(const String& name, size_t& value);
		void GetValue(const String& name, int& value);
		void GetValue(const String& name, unsigned char& value);
		void GetValue(const String& path, const String& name, String& value);
		void GetValue(const String& path, const String& name, size_t& value);
		void GetValue(const String& path, const String& name, int& value);
		void GetValue(const String& path, const String& name, bool& value);
		void GetValue(const String& path, const String& name, unsigned char& value);
		typedef std::vector<String> Children;
		void GetChildren(const String& parent, Children& children);

		bool SerializeToTree(IMOTreeManager& treeManager);
		bool Exist(const String& path, const String& name);
		int GetCount(const String& tagValue, const String& tagName = "Path");

	private:
		bool parseNode(const char* node, IMOTreeManager& treeManager);
		bool getNodeValue(const char* node, const String& name, String& value);
		void filterNodeValue(String& value);

	private:
		String m_buffer;
		unsigned int m_curPos;
	};
}
