/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "Logger/Logger.h"

//namespace NS_Logging
//{
//	class Logger;
//	Logger& GetLogger(const char* name);
//}

// Get logger for NAME
#define GLINFO(NAME, ...)	\
	LOG_INFO_(NS_Logging::GetLogger(NAME),##__VA_ARGS__);

#define GLWARN(NAME, ...)	\
	LOG_WARING_(NS_Logging::GetLogger(NAME),##__VA_ARGS__);

#define GLDEBUG(NAME, ...)	\
	LOG_DEBUG_(NS_Logging::GetLogger(NAME),##__VA_ARGS__);

#define GLERROR(NAME, ...)	\
	LOG_ERROR_(NS_Logging::GetLogger(NAME),##__VA_ARGS__);

// Get_Defaul_Logger - get logger for defined default variable c_LogName (should bedefined by user)
#define GDLINFO(...)	\
	LOG_INFO_(NS_Logging::GetLogger(c_LogName),##__VA_ARGS__);

#define GDLWARN(...)	\
	LOG_WARNING_(NS_Logging::GetLogger(c_LogName),##__VA_ARGS__);

#define GDLDEBUG(...)	\
	LOG_DEBUG_(NS_Logging::GetLogger(c_LogName),##__VA_ARGS__);

#define GDLERROR(...)	\
	LOG_ERROR_(NS_Logging::GetLogger(c_LogName),##__VA_ARGS__);

#define GDLDUMP(...)	\
	LOG_DUMP_(NS_Logging::GetLogger(c_LogName),##__VA_ARGS__);

#define GDCRITICAL(...)	\
	LOG_CRITICAL_(NS_Logging::GetLogger(c_LogName),##__VA_ARGS__);


// use following macroses with declared variable m_logger
#define LDEBUG(msg, ...) LOG_DEBUG_(m_logger, msg,##__VA_ARGS__)
#define LERROR(msg, ...) LOG_ERROR_(m_logger, msg,##__VA_ARGS__)
#define LINFO(msg, ...)  LOG_INFO_(m_logger, msg,##__VA_ARGS__)
#define LWARN(msg, ...) LOG_WARNING_(m_logger, msg,##__VA_ARGS__)
#define LDUMP(msg, ...) LOG_DUMP_(m_logger, msg,##__VA_ARGS__)
#define LCRITICAL(msg, ...) LOG_CRITICAL_(m_logger, msg,##__VA_ARGS__)
