#pragma once

#include "Errors.h"
#include "commontypes.h"

#include "common/platform.h"


#ifndef DM_IPCENGINE_API

#ifdef PLATFORM_LINUX
#define DM_IPCENGINE_API
#elif defined(PLATFORM_WINDOWS)
#ifdef DM_IPCENGINE_EXPORTS
#define DM_IPCENGINE_API __declspec(dllexport)
#else
#define DM_IPCENGINE_API __declspec(dllimport)
#endif // DM_IPCENGINE_EXPORTS
#else
#define DM_IPCENGINE_API
#endif

#endif

namespace NS_DM_Client
{

class IFIFOWrapper;

class DM_IPCENGINE_API TestingAPI
{
public:
    TestingAPI();
    ~TestingAPI();

    bool Start();
    bool Stop();

    StatusCode GetValueFromTree(const String& uri, String& value);
    StatusCode RequestFirmwareUpdate(const String& profileName, bool userInitiated);

    void release();

private:
    TestingAPI(TestingAPI&);
    TestingAPI& operator=(TestingAPI&);

    IFIFOWrapper* m_fifo_request;
    IFIFOWrapper* m_fifo_response;
};

}
