/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once
#include "platform.h"

#ifdef PLATFORM_LINUX
#define TESTCLIENTADAPTER_API
#elif defined(PLATFORM_WINDOWS)
#ifdef TESTCLIENTADAPTER_EXPORTS
#define TESTCLIENTADAPTER_API __declspec(dllexport)
#else
#define TESTCLIENTADAPTER_API __declspec(dllimport)
#endif // TESTCLIENTADAPTER_EXPORTS
#else
#define TESTCLIENTADAPTER_API
#endif

namespace NS_DM_Client
{
	class IClientAdapter;
	class DevInfo;
	class DevDetail;
	class WiMAXSupp;
	namespace NS_DM_Diagnostics
	{
		class WiMAX_Diagnostics;
	}

	class TESTCLIENTADAPTER_API TestClientAdapter
	{
	public:
		TestClientAdapter();
		~TestClientAdapter();

		bool GetManagementObject(const char* objectName);
		bool GetManagementTree(const char* uri);
		bool GetClientProfiles();
		bool GetProfileActivationStatus(bool& isActive); // check if current profile as active

		bool SetManagementObject(const char* objectName);
		bool Set(const char* filename);
		bool SetEMSK(const char* emsk);
		bool SetManufacturer(const char* manufacturer);
		bool SetModel(const char* model);
		bool SetDeviceID(const char* deviceID);
		bool SetWiMAXDiagnostics();

		bool CheckFirmware();
		bool StartDMSession(const char *alertType = 0);
		bool HandleProvision();
		bool HandleConfirmation();
		bool Subscribe();
		bool DRMDReadyRequest();
		bool HandleNetworkEntry(int hnspID, const char* operatorName);
		bool StartBootstrap();

	private:
		void fillInDevInfo(DevInfo& deviceInfo);
		void fillInDevDetail(DevDetail& deviceDetail);
		void fillInWiMAXSupp(WiMAXSupp& wimaxSupp);
		void fillInWiMAXDiagnostics(NS_DM_Diagnostics::WiMAX_Diagnostics& wimaxDiagnostics);

	private:
		NS_DM_Client::IClientAdapter* m_clientAdapter;
	};
}

