/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.dmdemo.processor;

import com.funambol.framework.core.Alert;
import com.funambol.framework.core.Util;
import com.funambol.framework.core.dm.ddf.DevInfo;
import com.funambol.framework.engine.dm.DeviceDMState;
import com.funambol.framework.engine.dm.LegacyManagementProcessorAdapter;
import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.engine.dm.ManagementOperation;
import com.funambol.framework.engine.dm.ManagementOperationResult;
import com.funambol.framework.tools.IOTools;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jboss.logging.Logger;

public class GenericProcessor
extends LegacyManagementProcessorAdapter
implements Serializable {
    protected DataSource datasource = null;
    protected String sessionId = null;
    protected DeviceDMState dmState = null;
    protected String sessionsDirectory = null;
    protected final Logger log = Logger.getLogger((String)GenericProcessor.class.getName());
    protected int step = 0;
    private String name;
    private String jndiDataSourceName = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getJndiDataSourceName() {
        return this.jndiDataSourceName;
    }

    public void setJndiDataSourceName(String jndiDataSourceName) throws ManagementException {
        this.jndiDataSourceName = jndiDataSourceName;
        if (jndiDataSourceName == null) {
            this.datasource = null;
        }
        try {
            InitialContext ctx = new InitialContext();
            this.datasource = (DataSource)ctx.lookup(jndiDataSourceName);
        }
        catch (NamingException e) {
            throw new ManagementException("Data source " + jndiDataSourceName + " not found", (Throwable)e);
        }
    }

    public GenericProcessor() {
        this.sessionsDirectory = System.getProperty("com.funambol.dmdemo.resultsDirectory");
        if (this.sessionsDirectory == null) {
            this.sessionsDirectory = ".";
        }
    }

    public void beginSession(String sessionId, Principal p, int type, DevInfo devInfo, DeviceDMState dmState) throws ManagementException {
        if (this.log.isEnabled(Logger.Level.DEBUG)) {
            this.log.debug((Object)"Starting a new DM management session");
            this.log.debug((Object)("sessionId: " + sessionId));
            this.log.debug((Object)("principal: " + p));
            this.log.debug((Object)("type: " + type));
            this.log.debug((Object)("deviceId: " + devInfo));
        }
        this.sessionId = sessionId;
        this.dmState = dmState;
    }

    public void endSession(int completionCode) throws ManagementException {
        if (this.log.isEnabled(Logger.Level.DEBUG)) {
            this.log.debug((Object)("End a DM management session with sessionId: " + this.sessionId));
        }
    }

    void setGenericAlerts(Alert[] genericAlerts) {
        int numAlerts = genericAlerts.length;
        this.log.info((Object)("SetGenericAlerts (num. alerts: " + numAlerts + ")"));
        for (int i = 0; i < numAlerts; ++i) {
            this.log.info((Object)("Alert[" + i + "]: " + Util.toXML((Object)genericAlerts[i])));
        }
    }

    public ManagementOperation[] getNextOperations() throws ManagementException {
        ManagementOperation[] operations = null;
        if (this.step == 0) {
            try {
                operations = this.readOperations(this.dmState.id).toArray(new ManagementOperation[0]);
            }
            catch (IOException ex) {
                throw new ManagementException("Error reading the operations", (Throwable)ex);
            }
        } else {
            operations = new ManagementOperation[]{};
        }
        return operations;
    }

    public void setOperationResults(ManagementOperationResult[] results) throws ManagementException {
        ++this.step;
        String id = this.dmState.id;
        if (this.log.isEnabled(Logger.Level.TRACE)) {
            this.log.trace((Object)("update results for id: " + id));
        }
        ArrayList<ManagementOperationResult> resultsList = new ArrayList<ManagementOperationResult>(Arrays.asList(results));
        this.saveResults(resultsList, id);
        this.dmState.state = (byte)67;
    }

    private List<ManagementOperation> readOperations(String dmStateId) throws IOException {
        File operationsFile = new File(this.sessionsDirectory + File.separator + dmStateId + File.separator + "operations.xml");
        if (this.log.isEnabled(Logger.Level.TRACE)) {
            this.log.trace((Object)("get operations for id: " + dmStateId));
        }
        if (!operationsFile.exists()) {
            return null;
        }
        String xmlOperations = IOTools.readFileString((File)operationsFile);
        if (xmlOperations == null) {
            return new ArrayList<ManagementOperation>();
        }
        XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(xmlOperations.getBytes()));
        ArrayList operationsList = (ArrayList)decoder.readObject();
        return operationsList;
    }

    private void saveResults(List<ManagementOperationResult> resultsList, String id) {
        block2: {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(bout);
            encoder.writeObject(resultsList);
            encoder.flush();
            encoder.close();
            String directory = this.sessionsDirectory + File.separator + id;
            File resultsFileDir = new File(directory);
            resultsFileDir.mkdirs();
            File resultsFile = new File(directory + File.separator + "results.xml");
            try {
                IOTools.writeFile((byte[])bout.toByteArray(), (File)resultsFile);
            }
            catch (Exception e) {
                this.log.debug((Object)"saveResults", (Throwable)e);
                if (!this.log.isEnabled(Logger.Level.FATAL)) break block2;
                this.log.fatal((Object)("Error saving results: " + e.getMessage()));
            }
        }
    }
}

