/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.dmdemo;

import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.tools.DBTools;
import com.funambol.framework.tools.IOTools;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jboss.logging.Logger;

public class TreeDiscoveryProcessorTools {
    private static final String SQL_INSERT_TREE_DISCOVERY_SESSION = "INSERT INTO fnbl_treediscovery_processor (id,root_node) values (?,?)";
    private static final String SQL_UPDATE_TREE_DISCOVERY_SESSION = "UPDATE fnbl_treediscovery_processor set root_node=? WHERE id=?";
    private static final String SQL_SELECT_TREE_DISCOVERY_SESSION = "SELECT id, root_node FROM fnbl_treediscovery_processor WHERE id=? ";
    private static final String SQL_DELETE_TREE_DISCOVERY = "DELETE FROM fnbl_treediscovery_processor WHERE id=?";
    private static final Logger log = Logger.getLogger((String)TreeDiscoveryProcessorTools.class.getName());
    private DataSource datasource = null;
    private String rootNode = null;
    private Map treeDiscoveryResults = null;
    private String sessionId = null;
    private String resultsDirectory = System.getProperty("com.funambol.dmdemo.resultsDirectory");

    private TreeDiscoveryProcessorTools() {
        if (this.resultsDirectory == null) {
            this.resultsDirectory = ".";
        }
    }

    public TreeDiscoveryProcessorTools(DataSource ds) {
        this();
        this.datasource = ds;
    }

    public Map getTreeDiscoveryResults() {
        if (this.treeDiscoveryResults == null) {
            return new HashMap();
        }
        return this.treeDiscoveryResults;
    }

    public void startNewManagementSession(String deviceId, String sessionId) throws ManagementException {
        this.sessionId = sessionId;
        this.rootNode = null;
        this.treeDiscoveryResults = null;
    }

    public void deleteSession() throws ManagementException {
        if (this.sessionId == null) {
            return;
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_DELETE_TREE_DISCOVERY);
            pStmt.setObject(1, this.sessionId);
            pStmt.executeUpdate();
            this.deleteResults(this.sessionId);
        }
        catch (Exception e) {
            try {
                throw new ManagementException("Error deleting the session", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
    }

    public void saveSession() throws ManagementException {
        if (this.sessionId == null) {
            throw new ManagementException("The sessionId must be != null");
        }
        if (this.rootNode == null) {
            throw new ManagementException("The root node must be != null");
        }
        int numUpdated = this.updateTreeDiscoverySession(this.rootNode);
        if (numUpdated == 0) {
            this.insertTreeDiscoverySession(this.rootNode);
        }
    }

    public void loadTreeSession(String sessionId) throws ManagementException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("loadTreeSession with sessionId: " + sessionId));
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String xmlOperationsResults = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_TREE_DISCOVERY_SESSION);
            pStmt.setObject(1, sessionId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                this.rootNode = rs.getString("root_node");
            }
            xmlOperationsResults = this.readResults(sessionId);
        }
        catch (Exception e) {
            try {
                throw new ManagementException("Error reading the session operations", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        if (xmlOperationsResults == null) {
            this.treeDiscoveryResults = new TreeMap();
        } else {
            XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(xmlOperationsResults.getBytes()));
            this.treeDiscoveryResults = (Map)decoder.readObject();
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("number of results: " + this.treeDiscoveryResults.size()));
        }
    }

    public String getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(String rootNode) {
        if (rootNode != null) {
            while (rootNode.endsWith("/")) {
                rootNode = rootNode.substring(0, rootNode.length() - 1);
            }
        }
        this.rootNode = rootNode;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this);
        sb.append("sessionId", (Object)this.sessionId);
        sb.append("rootNode", (Object)this.rootNode);
        sb.append("num.results treeDiscovery", (Object)(this.treeDiscoveryResults == null ? "null" : String.valueOf(this.treeDiscoveryResults.size())));
        return sb.toString();
    }

    private int updateTreeDiscoverySession(String rootNode) throws ManagementException {
        if (this.sessionId == null) {
            return 0;
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int numUpdated = 0;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_UPDATE_TREE_DISCOVERY_SESSION);
            pStmt.setObject(1, rootNode);
            pStmt.setObject(2, this.sessionId);
            numUpdated = pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error updating the treeDiscoverySession with session: " + this.sessionId, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
        return numUpdated;
    }

    private void insertTreeDiscoverySession(String rootNode) throws ManagementException {
        if (this.sessionId == null) {
            return;
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_INSERT_TREE_DISCOVERY_SESSION);
            pStmt.setObject(1, this.sessionId);
            pStmt.setObject(2, rootNode);
            pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the session", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
    }

    private void deleteResults(String dmStateId) throws IOException {
        File directory = new File(this.resultsDirectory + File.separator + dmStateId);
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].delete()) continue;
                throw new IOException("Error deleting file '" + files[i].getAbsolutePath() + "'");
            }
        }
        directory.delete();
    }

    private String readResults(String dmStateId) throws IOException {
        File resultsFile = new File(this.resultsDirectory + File.separator + dmStateId + File.separator + "results.xml");
        if (!resultsFile.exists()) {
            return null;
        }
        return IOTools.readFileString((File)resultsFile);
    }
}

