/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.dmdemo;

import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.DBTools;
import com.funambol.framework.tools.MD5;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.jboss.logging.Logger;

public class RegistrationTools {
    private static final String DEFAULT_USER_NAME = "funambol";
    private static final String DEFAULT_USER_PASSWORD = "funambol";
    private static final String DEFAULT_DEVICE_DESCRIPTION = "phone for DM demo";
    private static final String DEFAULT_DEVICE_SERVER_PASSWORD = "srvpwd";
    private static final String DEFAULT_DEVICE_TYPE = "phone";
    private static final String SQL_INSERT_NEW_USER_DM_DEMO = "INSERT INTO fnbl_user_dm_demo  (name, company, job, address, city, zip, state, country, email, phone, device_id, password)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_SELECT_USER_DM_DEMO = "SELECT password FROM fnbl_user_dm_demo WHERE device_id=?";
    private static final String SQL_INSERT_USER = "INSERT INTO fnbl_user (username, password, internal_user) values (?,?, 'N')";
    private static final String SQL_INSERT_DEVICE = "INSERT INTO fnbl_device (id, description, type, digest, server_password)  values (?,?,?,?,?)";
    private static final String SQL_SELECT_USER = "SELECT * FROM fnbl_user WHERE username=?";
    private static final String SQL_SELECT_DEVICE = "SELECT * FROM fnbl_device WHERE id=?";
    private static final String SQL_SELECT_ID_PRINCIPAL = "SELECT counter FROM fnbl_id WHERE idspace=?";
    private static final String SQL_UPDATE_ID_PRINCIPAL = "UPDATE fnbl_id SET counter=? WHERE idspace=?";
    private static final String SQL_SELECT_PRINCIPAL = "SELECT * FROM fnbl_principal WHERE username=? AND device=?";
    private static final String SQL_INSERT_PRINCIPAL = "INSERT INTO fnbl_principal (id, username, device) values (?,?,?)";
    private static final Logger log = Logger.getLogger((String)RegistrationTools.class.getName());
    private DataSource datasource = null;

    private RegistrationTools() {
    }

    public RegistrationTools(DataSource ds) {
        this.datasource = ds;
    }

    public boolean loginUser(String deviceId, String password) throws ManagementException {
        return this.checkIfUserAlreadyExists(deviceId);
    }

    public void registerNewUser(String name, String company, String job, String address, String city, String zip, String state, String country, String email, String phone, String deviceId) throws ManagementException {
        if (name == null || name.equals("") || deviceId == null || deviceId.equals("") || email == null || email.equals("")) {
            throw new ManagementException("Name, Email, and Device Id are required");
        }
        this.insertNewUser(name, company, job, address, city, zip, state, country, email, phone, deviceId, "");
        String digest = this.setSync4jUserDigest();
        String clearUsername = this.setSync4jUserClear();
        this.setSync4jDevice(deviceId, digest);
        this.setSync4jPrincipal(digest, deviceId);
        this.setSync4jPrincipal(clearUsername, deviceId);
    }

    public void insertNewUser(String name, String company, String job, String address, String city, String zip, String state, String country, String email, String phone, String deviceId, String password) throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_INSERT_NEW_USER_DM_DEMO);
            if (name != null) {
                pStmt.setObject(1, name);
            } else {
                pStmt.setNull(1, 12);
            }
            if (company != null) {
                pStmt.setObject(2, company);
            } else {
                pStmt.setNull(2, 12);
            }
            if (job != null) {
                pStmt.setObject(3, job);
            } else {
                pStmt.setNull(3, 12);
            }
            if (address != null) {
                pStmt.setObject(4, address);
            } else {
                pStmt.setNull(4, 12);
            }
            if (city != null) {
                pStmt.setObject(5, city);
            } else {
                pStmt.setNull(5, 12);
            }
            if (zip != null) {
                pStmt.setObject(6, zip);
            } else {
                pStmt.setNull(6, 12);
            }
            if (state != null) {
                pStmt.setObject(7, state);
            } else {
                pStmt.setNull(7, 12);
            }
            if (country != null) {
                pStmt.setObject(8, country);
            } else {
                pStmt.setNull(8, 12);
            }
            if (email != null) {
                pStmt.setObject(9, email);
            } else {
                pStmt.setNull(9, 12);
            }
            if (phone != null) {
                pStmt.setObject(10, phone);
            } else {
                pStmt.setNull(10, 12);
            }
            if (deviceId != null) {
                pStmt.setObject(11, deviceId);
            } else {
                pStmt.setNull(11, 12);
            }
            if (password != null) {
                pStmt.setObject(12, password);
            } else {
                pStmt.setNull(12, 12);
            }
            int temp = pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the new user", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
    }

    public boolean checkIfUserAlreadyExists(String deviceId) throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean deviceFound = false;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_USER_DM_DEMO);
            pStmt.setObject(1, deviceId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                deviceFound = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error reading the user", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        return deviceFound;
    }

    private String setSync4jUserDigest() throws ManagementException {
        String name = "funambol";
        String password = "funambol";
        String digest = new String(Base64.encode((byte[])MD5.digest((byte[])(name + ":" + password).getBytes())));
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean userFound = false;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_USER);
            pStmt.setObject(1, digest);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                userFound = true;
            }
            if (!userFound) {
                pStmt = con.prepareStatement(SQL_INSERT_USER);
                pStmt.setObject(1, digest);
                pStmt.setObject(2, "");
                pStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the user", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        return digest;
    }

    private String setSync4jUserClear() throws ManagementException {
        String name = "funambol";
        String password = "funambol";
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean userFound = false;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_USER);
            pStmt.setObject(1, name);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                userFound = true;
            }
            if (!userFound) {
                pStmt = con.prepareStatement(SQL_INSERT_USER);
                pStmt.setObject(1, name);
                pStmt.setObject(2, password);
                pStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the user", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        return name;
    }

    private void setSync4jDevice(String deviceId, String digest) throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean deviceFound = false;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_DEVICE);
            pStmt.setObject(1, deviceId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                deviceFound = true;
            }
            if (!deviceFound) {
                pStmt = con.prepareStatement(SQL_INSERT_DEVICE);
                pStmt.setObject(1, deviceId);
                pStmt.setObject(2, DEFAULT_DEVICE_DESCRIPTION);
                pStmt.setObject(3, DEFAULT_DEVICE_TYPE);
                pStmt.setObject(4, digest);
                pStmt.setObject(5, DEFAULT_DEVICE_SERVER_PASSWORD);
                pStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the device", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
    }

    private void setSync4jPrincipalDigest(String digest, String deviceId) throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean principalFound = false;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_PRINCIPAL);
            pStmt.setObject(1, digest);
            pStmt.setObject(2, deviceId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                principalFound = true;
            }
            if (!principalFound) {
                pStmt = con.prepareStatement(SQL_INSERT_PRINCIPAL);
                pStmt.setInt(1, this.getSync4jPrincipalId());
                pStmt.setObject(2, digest);
                pStmt.setObject(3, deviceId);
                pStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the principal", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
    }

    private void setSync4jPrincipal(String username, String deviceId) throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean principalFound = false;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_PRINCIPAL);
            pStmt.setObject(1, username);
            pStmt.setObject(2, deviceId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                principalFound = true;
            }
            if (!principalFound) {
                pStmt = con.prepareStatement(SQL_INSERT_PRINCIPAL);
                pStmt.setInt(1, this.getSync4jPrincipalId());
                pStmt.setObject(2, username);
                pStmt.setObject(3, deviceId);
                pStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the principal", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
    }

    private int getSync4jPrincipalId() throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int id = -1;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_ID_PRINCIPAL);
            pStmt.setObject(1, "principal");
            rs = pStmt.executeQuery();
            while (rs.next()) {
                id = rs.getInt(1);
            }
            pStmt = con.prepareStatement(SQL_UPDATE_ID_PRINCIPAL);
            pStmt.setInt(1, id + 1);
            pStmt.setObject(2, "principal");
            pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error reading id for the principal", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        return id;
    }

    private void showMethods(Object obj) {
        System.out.println("Methods of: '" + obj.getClass().getName() + "'");
        Class<?> cObj = obj.getClass();
        Method[] methods = cObj.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            System.out.println(methods[i].toString());
        }
    }
}

