/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.dmdemo;

import com.funambol.dmdemo.DMDemoBean;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;

public class LoginFilter
implements Filter {
    private static final Logger log = Logger.getLogger((String)LoginFilter.class.getName());
    private static String DELIMITER = ",";
    private static final String PAGE_TO_FORWARD = "jsp/login.jsp";
    private String skipPages = null;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession();
        DMDemoBean dmDemoBean = null;
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Request page: " + request.getRequestURL()));
        }
        if (this.skipPages != null && !this.skipPages.isEmpty()) {
            StringTokenizer sp = new StringTokenizer(this.skipPages, DELIMITER);
            String uri = request.getRequestURI();
            while (sp.hasMoreTokens()) {
                if (uri.indexOf(sp.nextToken().trim()) <= 0) continue;
                chain.doFilter(req, res);
                if (log.isEnabled(Logger.Level.TRACE)) {
                    log.trace((Object)("Skip session for URI: " + uri));
                }
                return;
            }
        }
        try {
            dmDemoBean = (DMDemoBean)session.getAttribute("dmDemoBean");
        }
        catch (Exception e) {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)("Error getting dmDemoBean from the session: " + e));
                log.trace((Object)"Forward to jsp/login.jsp");
            }
            this.redirect(PAGE_TO_FORWARD, request, response);
            return;
        }
        if (dmDemoBean == null) {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"DmDemoBean not in session");
                log.trace((Object)"Forward to jsp/login.jsp");
            }
            this.redirect(PAGE_TO_FORWARD, request, response);
            return;
        }
        boolean userIsLogged = dmDemoBean.isUserLogged();
        if (!userIsLogged) {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"User not logged. Forward to jsp/login.jsp");
            }
            this.redirect(PAGE_TO_FORWARD, request, response);
            return;
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"User logged.");
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig filterConfig) {
        this.skipPages = filterConfig.getInitParameter("skip-pages");
    }

    public void destroy() {
    }

    private void redirect(String page, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendRedirect(request.getContextPath() + "/" + page);
    }
}

