/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.bootstrap.client;

import com.funambol.framework.core.Constants;
import com.funambol.framework.core.dm.bootstrap.BootStrap;
import com.funambol.framework.core.dm.bootstrap.Characteristic;
import com.funambol.framework.core.dm.bootstrap.Parm;
import com.funambol.framework.core.dm.bootstrap.WapProvisioningDoc;
import com.funambol.framework.core.dm.ddf.MgmtTree;
import com.funambol.framework.engine.dm.TreeNode;
import com.funambol.framework.server.error.ServerFailureException;
import com.funambol.server.engine.dm.ejb.ManagementRemote;
import java.util.Hashtable;
import javax.naming.InitialContext;

public class ClientBootstrap {
    public static final String MANAGEMENT_EJB_JNDI_NAME = "ejb:FunambolDMServer/funambol-server.jar//ManagementBean!com.funambol.server.engine.dm.ejb.ManagementRemote";
    public static final String CONTEXT_URL_PREFIXES = "org.jboss.ejb.client.naming";

    public static void main(String[] args) throws Exception {
        int messageType;
        if (args.length != 6) {
            System.out.println("Use com.funambol.bootstrap.client.Bootstrap <messageType> <deviceId> <phoneNumber> <accountName> <userName> <password>");
            System.exit(-1);
        }
        System.out.println("Lookup management bean");
        try {
            messageType = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            messageType = -1;
        }
        String deviceId = args[1];
        String phoneNumber = args[2];
        String accountName = args[3];
        String username = args[4];
        String password = args[5];
        BootStrap bootstrap = new BootStrap(phoneNumber, messageType, null, null, null, null, accountName, username, password, deviceId, null, null, null, -1, false, "12345", "GetDeviceDetails");
        if (messageType == 0) {
            bootstrap.setWapProvisioningDoc(ClientBootstrap.getWapProvisioninDoc());
        } else if (messageType == 1) {
            bootstrap.setNodes(ClientBootstrap.getNodes());
        } else if (messageType == 2) {
            bootstrap.setMgmtTree(ClientBootstrap.getMgmtTree());
        } else {
            System.out.println(args[0] + " is not an allowed message type. Valid options are:");
            System.out.println("0 - WAP profile");
            System.out.println("1 - PLAIN profile");
            System.out.println("2 - DM profile");
            System.exit(-1);
        }
        ManagementRemote remote = ClientBootstrap.getManagementBeanInstance();
        System.out.println("Bootstrapping");
        remote.bootstrap(bootstrap);
        System.out.println("Bootstrap sent");
    }

    private static TreeNode[] getNodes() {
        TreeNode serverPassword = new TreeNode("./SyncML/DMAcc/funambolAccount/ServerPW", (Object)"testCon");
        TreeNode conRef = new TreeNode("./SyncML/DMAcc/funambolAccount/ConRef", (Object)"testCon");
        TreeNode con = new TreeNode("./SyncML/DMAcc/Con/TestCon", null, "node");
        TreeNode conId = new TreeNode("./SyncML/DMAcc/Con/TestCon/Id", (Object)"testCon");
        TreeNode[] nodes = new TreeNode[]{serverPassword, conRef, con, conId};
        return nodes;
    }

    private static MgmtTree getMgmtTree() {
        MgmtTree tree = new MgmtTree();
        tree.setVerDTD(Constants.DTD_1_2);
        return tree;
    }

    private static WapProvisioningDoc getWapProvisioninDoc() {
        WapProvisioningDoc wapProvisioningDoc = new WapProvisioningDoc("1.0");
        Characteristic application = new Characteristic("APPLICATION");
        Parm applicationId = new Parm("APPID", "w7");
        Parm name = new Parm("NAME", "account name");
        Parm providerId = new Parm("PROVIDER-ID", "provider name");
        Parm toNap = new Parm("TO-NAPID", "TEST");
        application.add(applicationId);
        application.add(name);
        application.add(providerId);
        application.add(toNap);
        Characteristic napDef = new Characteristic("NAPDEF");
        Parm napIp = new Parm("NAPID", "TEST");
        Parm bearer = new Parm("BEARER", "22");
        Parm napAddress = new Parm("NAP-ADDRESS", "nap-address");
        napDef.add(napIp);
        napDef.add(bearer);
        napDef.add(napAddress);
        wapProvisioningDoc.addCharacteristic(application);
        wapProvisioningDoc.addCharacteristic(napDef);
        return wapProvisioningDoc;
    }

    private static ManagementRemote getManagementBeanInstance() throws ServerFailureException {
        ManagementRemote remote;
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("java.naming.factory.url.pkgs", CONTEXT_URL_PREFIXES);
            InitialContext ctx = new InitialContext(props);
            remote = (ManagementRemote)ctx.lookup(MANAGEMENT_EJB_JNDI_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServerFailureException((Throwable)e);
        }
        return remote;
    }
}

