/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.test.tools;

import com.funambol.framework.core.Constants;
import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.tools.WBXMLTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public final class HttpClientConnection
implements Constants {
    public static String LOG_NAME = "funambol.test.tools.PostSyncML";
    private static final Logger log = Logger.getLogger((String)HttpClientConnection.class.getName());
    private final HttpURLConnection conn;
    private OutputStream out;
    private final String serverAddress;
    private String lastResponse;
    private String lastMessage;

    public HttpClientConnection(String strServerAddress) throws IOException {
        if (strServerAddress == null) {
            throw new NullPointerException("strServerAddress parameter is null");
        }
        this.serverAddress = strServerAddress;
        if (!this.serverAddress.startsWith("http:")) {
            throw new IllegalArgumentException("server address must start with 'http:'");
        }
        URL u = null;
        try {
            u = new URL(this.serverAddress);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("server address is not a valid URL");
        }
        this.lastResponse = null;
        this.lastMessage = null;
        URLConnection obj = u.openConnection();
        if (!(obj instanceof HttpURLConnection)) {
            // empty if block
        }
        this.conn = (HttpURLConnection)obj;
        this.conn.setDoOutput(true);
        this.conn.setDoInput(true);
        this.conn.setAllowUserInteraction(false);
        this.conn.setRequestMethod("POST");
        this.conn.setUseCaches(false);
        this.conn.setInstanceFollowRedirects(false);
        this.conn.setRequestProperty("User-Agent", this.getClass().toString());
    }

    public SyncML sendMessage(SyncML msg) throws Exception {
        String syncML = this.marshallSyncML(msg);
        return this.sendMessage(syncML);
    }

    public SyncML sendMessage(String msg) throws IOException, Sync4jException, RepresentationException {
        byte[] yaData = msg.getBytes();
        this.conn.setRequestProperty("Content-Type", "application/vnd.syncml+xml");
        this.conn.setRequestProperty("Content-Length", "" + yaData.length);
        this.out = this.conn.getOutputStream();
        this.out.write(yaData);
        this.out.flush();
        InputStream in = this.conn.getInputStream();
        int iResponseCode = this.conn.getResponseCode();
        if (iResponseCode != 200) {
            String error = "Response status: " + iResponseCode + ", Response message: " + this.conn.getResponseMessage();
            throw new IOException(error);
        }
        String strResponseContentType = this.conn.getContentType();
        if (strResponseContentType == null) {
            throw new IOException("Content type: " + strResponseContentType);
        }
        if (!strResponseContentType.equals("application/vnd.syncml+xml")) {
            throw new IOException("Content type: " + strResponseContentType + " (should be " + "application/vnd.syncml+xml" + ")");
        }
        this.lastMessage = msg;
        int iResponseContentLength = this.conn.getContentLength();
        if (iResponseContentLength < 1) {
            throw new IOException("Response content length: " + iResponseContentLength);
        }
        byte[] yaResponse = new byte[iResponseContentLength];
        int n = 0;
        int iBytesRead = 0;
        do {
            if ((n = in.read(yaResponse, iBytesRead, yaResponse.length - iBytesRead)) <= 0) continue;
            iBytesRead += n;
        } while (n != -1);
        if (iBytesRead != iResponseContentLength) {
            // empty if block
        }
        this.lastResponse = new String(yaResponse);
        SyncML syncML = null;
        try {
            syncML = this.unmarshallSyncML(this.lastResponse);
        }
        catch (Exception e) {
            throw new Sync4jException(e);
        }
        return syncML;
    }

    public SyncML sendWBXMLMessage(byte[] msg) throws IOException, Sync4jException, RepresentationException {
        byte[] yaData = msg;
        this.conn.setRequestProperty("Content-Type", "application/vnd.syncml+wbxml");
        this.conn.setRequestProperty("Content-Length", "" + yaData.length);
        this.out = this.conn.getOutputStream();
        this.out.write(yaData);
        this.out.flush();
        InputStream in = this.conn.getInputStream();
        int iResponseCode = this.conn.getResponseCode();
        if (iResponseCode != 200) {
            String error = "Response status: " + iResponseCode + ", Response message: " + this.conn.getResponseMessage();
            throw new IOException(error);
        }
        String strResponseContentType = this.conn.getContentType();
        if (strResponseContentType == null) {
            throw new IOException("Content type: " + strResponseContentType);
        }
        if (!strResponseContentType.equals("application/vnd.syncml+wbxml")) {
            throw new IOException("Content type: " + strResponseContentType + " (should be " + "application/vnd.syncml+wbxml" + ")");
        }
        int iResponseContentLength = this.conn.getContentLength();
        if (iResponseContentLength < 1) {
            throw new IOException("Response content length: " + iResponseContentLength);
        }
        byte[] yaResponse = new byte[iResponseContentLength];
        int n = 0;
        int iBytesRead = 0;
        do {
            if ((n = in.read(yaResponse, iBytesRead, yaResponse.length - iBytesRead)) <= 0) continue;
            iBytesRead += n;
        } while (n != -1);
        if (iBytesRead != iResponseContentLength) {
            // empty if block
        }
        String xmlResponse = WBXMLTools.wbxmlToXml((byte[])yaResponse);
        SyncML syncML = null;
        try {
            syncML = this.unmarshallSyncML(xmlResponse);
        }
        catch (Exception e) {
            throw new Sync4jException(e);
        }
        return syncML;
    }

    public void close() {
        if (this.conn != null) {
            this.conn.disconnect();
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.serverAddress;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public String getLastResponse() {
        return this.lastResponse;
    }

    private SyncML unmarshallSyncML(String response) throws Sync4jException {
        SyncML syncML = null;
        try {
            IBindingFactory f = BindingDirectory.getFactory(SyncML.class);
            IUnmarshallingContext c = f.createUnmarshallingContext();
            syncML = (SyncML)c.unmarshalDocument((InputStream)new ByteArrayInputStream(response.getBytes()), null);
        }
        catch (JiBXException e) {
            e.printStackTrace();
            throw new Sync4jException(e);
        }
        return syncML;
    }

    private String marshallSyncML(SyncML syncML) throws Sync4jException {
        String msg = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IBindingFactory f = BindingDirectory.getFactory(SyncML.class);
            IMarshallingContext c = f.createMarshallingContext();
            c.setIndent(0);
            c.marshalDocument((Object)syncML, "UTF-8", null, (OutputStream)bout);
            msg = new String(bout.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Sync4jException(e);
        }
        return msg;
    }
}

