/*
 * Simplified Chinese translation
 * By DavidHu
 * 09 April 2007
 */

Ext.UpdateManager.defaults.indicatorText = '<div class="loading-indicator">ロード中...</div>';

if(Ext.View){
   Ext.View.prototype.emptyText = "";
}

if(Ext.grid.GridPanel){
   Ext.grid.GridPanel.prototype.ddText = "{0} 行選択";
}

if(Ext.TabPanelItem){
   Ext.TabPanelItem.prototype.closeText = "閉じる";
}

if(Ext.form.Field){
   Ext.form.Field.prototype.invalidText = "値が正しくありません";
}

Date.monthNames = [
   "1月",
   "2月",
   "3月",
   "4月",
   "5月",
   "6月",
   "7月",
   "8月",
   "9月",
   "10月",
   "11月",
   "12月"
];

Date.dayNames = [
   "日",
   "月",
   "火",
   "水",
   "木",
   "金",
   "土"
];

if(Ext.MessageBox){
   Ext.MessageBox.buttonText = {
      ok     : "OK",
      cancel : "キャンセル",
      yes    : "はい",
      no     : "いいえ"
   };
}

if(Ext.util.Format){
   Ext.util.Format.date = function(v, format){
      if(!v) return "";
      if(!(v instanceof Date)) v = new Date(Date.parse(v));
      return v.dateFormat(format || "y年m月d日");
   };
}

if(Ext.DatePicker){
   Ext.apply(Ext.DatePicker.prototype, {
      todayText         : "今日",
      minText           : "最早の日付を入力してください",
      maxText           : "最遅の日付を入力してくださ",
      disabledDaysText  : "",
      disabledDatesText : "",
      monthNames        : Date.monthNames,
      dayNames          : Date.dayNames,
      nextText          : '翌月 (Control+Right)',
      prevText          : '前月 (Control+Left)',
      monthYearText     : '月の選択 (Control+Up/Down で年の変更年)',
      todayTip          : "{0} (スペースキー)",
      format            : "y年m月d日",
      okText            : "OK",
      cancelText        : "キャンセル"
   });
}

if(Ext.PagingToolbar){
   Ext.apply(Ext.PagingToolbar.prototype, {
      beforePageText : "",
      afterPageText  : " / {0} ページ",
      firstText      : "最初",
      prevText       : "次ページ",
      nextText       : "前ページ",
      lastText       : "最後",
      refreshText    : "更新",
      displayMsg     : "{0} - {1} / {2} を表示",
      emptyMsg       : 'データがありません'
   });
}

if(Ext.form.TextField){
   Ext.apply(Ext.form.TextField.prototype, {
      minLengthText : "最小 {0} 文字",
      maxLengthText : "最大 {0} 文字",
      blankText     : "入力は必須です",
      regexText     : "",
      emptyText     : null
   });
}

if(Ext.form.NumberField){
   Ext.apply(Ext.form.NumberField.prototype, {
      minText : "最小値は {0}",
      maxText : "最大値は {0}",
      nanText : "{0} は正しくありません"
   });
}

if(Ext.form.DateField){
   Ext.apply(Ext.form.DateField.prototype, {
      disabledDaysText  : "無効",
      disabledDatesText : "無効",
      minText           : "{0} 以降の日付を入力してくださ",
      maxText           : "{0} 以前の日付を入力してください",
      invalidText       : "{0} は正しい日付ではありません - 書式： {1}",
      format            : "y年m月d日"
   });
}

if(Ext.form.ComboBox){
   Ext.apply(Ext.form.ComboBox.prototype, {
      loadingText       : "ロード中...",
      valueNotFoundText : undefined
   });
}

if(Ext.form.VTypes){
   Ext.apply(Ext.form.VTypes, {
      emailText    : 'eメールアドレスを入力してください。書式: "user@domain.com"',
      urlText      : 'URLを入力してください。書式: "http:/'+'/www.domain.com"',
      alphaText    : '半角英字と _ が入力できます',
      alphanumText : '半角英数字と _ が入力できます'
   });
}

if(Ext.grid.GridView){
   Ext.apply(Ext.grid.GridView.prototype, {
      sortAscText  : "昇順",
      sortDescText : "降順",
      lockText     : "ロック",
      unlockText   : "ロック解除",
      columnsText  : "列"
   });
}

if(Ext.grid.PropertyColumnModel){
   Ext.apply(Ext.grid.PropertyColumnModel.prototype, {
      nameText   : "名称",
      valueText  : "値",
      dateFormat : "y年m月d日"
   });
}

if(Ext.layout.BorderLayout && Ext.layout.BorderLayout.SplitRegion){
   Ext.apply(Ext.layout.BorderLayout.SplitRegion.prototype, {
      splitTip            : "ドラッグしてサイズを変更できます.",
      collapsibleSplitTip : "ドラッグしてサイズを変更できます拖动来改变尺寸. ダブルクリックで隠れます."
   });
}
