// 表属性窗口定义
DBE.AttributeWindow = function(node,config) {
	
	// 获取表的schema和database
	var column ="";
	var database = "";
	var schema = "";
	var path_array =node.getPath('text').split("/");
  	 database = path_array[1];
  	 schema = path_array[2];  	
	
  	//根据表构造显示表属性的grid
	var cm = new Ext.grid.ColumnModel(
	[	 new Ext.grid.RowNumberer(),
		{header : LocaleLang.columName,dataIndex : 'columName',width:80},
		{header : LocaleLang.dataType,dataIndex : 'dataType'},
		{header : LocaleLang.maxlength,dataIndex : 'maxlength'},
		{header : LocaleLang.isNull,dataIndex : 'isNull'}
	]);

	var jsonds = new Ext.data.Store({
		proxy : new Ext.data.HttpProxy({
			url : '../control/loadTableAttribute'
		}),
		baseParams: {
		node : node.id,
		path  : node.path,
		text : node.text
		},
		reader : new Ext.data.JsonReader(
		    
			{root : 'columns'}, 
			[{name : 'columName'},
			{name : 'dataType'},
			{name : 'maxlength'},
			{name : 'isNull'}])
	});

	var _grid = new Ext.grid.GridPanel({
		ds : jsonds,
		cm : cm,
		scope : this,
		height : 200,
		listeners : {
			cellclick : function() {
				// 
				var record = this.getSelectionModel().getSelected();
				var columName = record.data['columName'];
				if (columName != '') {
					column = columName;
					jsonds1.proxy= new Ext.data.HttpProxy({
					url: '../control/loadColumnPar?column='+column
					});
 
					jsonds1.load();
				}
			}
		}
	  });
	  
	jsonds.load();

	
	//根据列名构造显示列详细信息的grid
	var cm1 = new Ext.grid.ColumnModel(
	[	 new Ext.grid.RowNumberer(),
		{header : LocaleLang.parameter,dataIndex : 'parameter',width:200},
		{header : LocaleLang.valuenum,dataIndex : 'value'}
	]);
	
	var jsonds1 = new Ext.data.Store({
		proxy : new Ext.data.HttpProxy({
			url : '../control/loadColumnPar'
		}),
		baseParams: {
		node : node.id,
		path  : node.path,
		text : node.text
		},
		reader : new Ext.data.JsonReader(
		    
			{root : 'root'}, 
			[{name : 'parameter'},
			{name : 'value'}])
	});
	
	var clumnGrid = new Ext.grid.GridPanel({
		
		ds : jsonds1,
		cm : cm1,
		scope : this,
		height : 200
	})
	
	jsonds1.load();
	
	
	var attributeForm = new Ext.form.FormPanel({
		id : 'attributeForm',
		frame : true,
		labelWidth : 70,
		buttonAlign : 'right',
		reader : new Ext.data.JsonReader({
			success : 'success',
			root : 'root'
		}, [{
			name : 'database'
		}, {
			name : 'schema'
		}, {
			name : 'tablename'
		}]),
		items : [{
			xtype : 'fieldset',
			title : '',
			autoHeight : true,
			defaults : {
				width : 270,
				msgTarget : 'side',
				xtype : 'textfield',
				selectOnFocus : true,
				readOnly: true
			},
			items : [{
				id : 'fldDatabase',
				fieldLabel : 'database',
				allowBlank : false,
				value :database,
				name : 'database'
			}, {
				id : 'fldSchema',
				fieldLabel : 'schema',
				allowBlank : false,
				value : schema,
				name : 'schema'
			}, {
				id : 'fldTablename',
				fieldLabel : 'table',
				allowBlank : false,
				value :node.text,
				name : 'tablename'
			}]
		}, _grid,clumnGrid],
		buttons : [{
			text : LocaleLang.close,
			scope : this,
			handler : function() {
				this.close();
			}
		}],
		keys : [{
			key : [10, 13],
			scope : this,
			fn : function() {
				this.close();
			}
		}]
	});

	// 准备配置参数
	var cfg = {
		title : LocaleLang.attributeWindow,
		id : 'attributeWindow',
		width : 300,
		height : 320,
		layout : 'fit',
		plain : true,
		frame : true,
		border : false,
		modal : true,
		draggable : false,
		resizable : false,
		autoScroll : true,
		closable : true,
		items : attributeForm
	};
	config = Ext.applyIf(config || {}, cfg);

	// call superclass
	DBE.AttributeWindow.superclass.constructor.call(this, config);

	// 公布属性
	this.attributeForm = attributeForm;
	this.successCallback = false;
}
Ext.extend(DBE.AttributeWindow, Ext.Window, {
});