package cn.com.qimingx.utils;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.ofbiz.base.util.UtilProperties;

/**
 * @author inc062805
 * 
 */
public class SQLUtils {
	public static void main(String[] args) {
		String sql = "select * from users where id=3 order by id,name desc";
		String cond = "aa=b and c=d";
		System.out.println(appendCondition(sql, cond));
	}

	// Logger
	private static final Log log = LogFactory.getLog(SQLUtils.class);

	// 取得 from 位置的表达式
	private static final Pattern FROM_PATTERN = Pattern.compile(
			"(^|\\s)(from)\\s", Pattern.CASE_INSENSITIVE);

	// 取得 order 位置的表达式
	private static final Pattern ORDER_PATTERN = Pattern.compile(
			"\\s(order)(\\s)+by\\s", Pattern.CASE_INSENSITIVE);

	public static Map<String, String> getDBInfos(DatabaseMetaData dbmd, Locale locale) {
		Map<String, String> infos = new LinkedHashMap<String, String>();
		try {
			// conn Infos
			String value = dbmd.getDatabaseProductName();
			value += "[" + dbmd.getDatabaseMajorVersion();
			value += "." + dbmd.getDatabaseMinorVersion() + "]";
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "DatabaseNameAndVersion", locale), value);

			value = dbmd.getDriverName();
			value += "[" + dbmd.getDriverMajorVersion();
			value += "." + dbmd.getDriverMinorVersion() + "]";
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "DriverNameAndVersion", locale), value);

			value = dbmd.getUserName();
			value += " connect to " + dbmd.getURL();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "UserName", locale), value);

			int iValue = dbmd.getJDBCMajorVersion();
			value = String.valueOf(iValue);
			iValue = dbmd.getJDBCMinorVersion();
			value += "." + iValue;
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "JdbcVersion", locale), value);

			// 事务
			boolean support = dbmd.supportsTransactions();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsTransactions", locale), String.valueOf(support));
			// TODO：检查事务支持级别
			support = dbmd.supportsStoredProcedures();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsStoredProcedures", locale), String.valueOf(support));
			// others
			support = dbmd.supportsStatementPooling();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsStatementPooling", locale), String.valueOf(support));
			support = dbmd.supportsBatchUpdates();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsBatchUpdates", locale), String.valueOf(support));
			support = dbmd.supportsGetGeneratedKeys();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsGetGeneratedKeys", locale), String.valueOf(support));
			support = dbmd.supportsConvert();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsConvert", locale), String.valueOf(support));

			// SQL
			value = UtilProperties.getMessage("JdbexplorerUILabels", "Full", locale);
			support = dbmd.supportsANSI92FullSQL();
			if (!support) {
				value = UtilProperties.getMessage("JdbexplorerUILabels", "Intermediate", locale);
				support = dbmd.supportsANSI92IntermediateSQL();
				if (!support) {
					value = UtilProperties.getMessage("JdbexplorerUILabels", "Entry", locale);
				}
			}
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsANSI92SQL", locale), value);

			support = dbmd.supportsSubqueriesInComparisons();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsSubqueriesInComparisons", locale), String.valueOf(support));
			support = dbmd.supportsSubqueriesInExists();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsSubqueriesInExists", locale), String.valueOf(support));
			support = dbmd.supportsSubqueriesInIns();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsSubqueriesInIns", locale), String.valueOf(support));
			support = dbmd.supportsCorrelatedSubqueries();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsCorrelatedSubqueries", locale), String.valueOf(support));
			support = dbmd.supportsSubqueriesInQuantifieds();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsSubqueriesInQuantifieds", locale), String.valueOf(support));

			support = dbmd.supportsSelectForUpdate();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsSelectForUpdate", locale), String.valueOf(support));
			support = dbmd.supportsUnion();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsUnion", locale), String.valueOf(support));
			support = dbmd.supportsUnionAll();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsUnionAll", locale), String.valueOf(support));
			support = dbmd.supportsGroupBy();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsGroupBy", locale), String.valueOf(support));
			support = dbmd.supportsOuterJoins();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsOuterJoins", locale), String.valueOf(support));
			support = dbmd.supportsLimitedOuterJoins();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsLimitedOuterJoins", locale), String.valueOf(support));
			support = dbmd.supportsFullOuterJoins();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SupportsFullOuterJoins", locale), String.valueOf(support));
			iValue = dbmd.getMaxStatementLength();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "MaxStatementLength", locale), String.valueOf(iValue));

			value = dbmd.getSQLKeywords();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SQLKeywords", locale), value);
			value = dbmd.getSystemFunctions();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "SystemFunctions", locale), value);
			value = dbmd.getNumericFunctions();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "NumericFunctions", locale), value);
			value = dbmd.getStringFunctions();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "StringFunctions", locale), value);
			value = dbmd.getTimeDateFunctions();
			infos.put(UtilProperties.getMessage("JdbexplorerUILabels", "TimeDateFunctions", locale), value);
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return infos;
	}

	/**
	 * 从查询 sql 语句生成 计算记录总数的count sql语句
	 */
	public static String getCountSQL(String sql) {
		Matcher fMatcher = FROM_PATTERN.matcher(sql);
		if (!fMatcher.find()) {
			throw new IllegalArgumentException("no from clause found in query");
		}
		int fLoc = fMatcher.start(2);

		Matcher oMatcher = ORDER_PATTERN.matcher(sql);
		int oLoc = oMatcher.find() ? oMatcher.start(1) : sql.length();

		return "select count(*) " + sql.substring(fLoc, oLoc);
	}

	/**
	 * 通过指定的sql语句，统计目标结果集的行数
	 * 
	 * @param sql
	 * @return
	 */
	public static long totalRowsBySQL(String sql, Statement stat) {
		long total = 0;
		String countSQL = SQLUtils.getCountSQL(sql);
		log.debug("count rows total:" + countSQL);
		try {
			ResultSet rs = stat.executeQuery(countSQL);
			if (rs.next()) {
				total = rs.getInt(1);
			} else {
				log.error("getTotalRows Error~~,total=0");
			}
			rs.close();
		} catch (SQLException e) {
			log.error("getTotalRows Error~~,total=0");
		}
		return total;
	}

	// 
	/**
	 * 向sql语句附件新的条件，如果已有where语句 则添加到后面，如果没有添加where语句
	 * 
	 * @param sql
	 * @param condition
	 * @return
	 */
	public static String appendCondition(final String sql,
			final String condition) {
		// check params
		if (condition == null || condition.length() == 0) {
			return sql;
		}

		// 取得order by 的位置
		Matcher oMatcher = ORDER_PATTERN.matcher(sql);
		int oLoc = oMatcher.find() ? oMatcher.start(1) : sql.length();

		StringBuilder str = new StringBuilder(sql.toLowerCase());
		String cond = null;
		if (str.lastIndexOf("where") == -1) {
			cond = "where (" + condition + ") ";
		} else {
			cond = "and (" + condition + ") ";
		}
		if (oLoc == sql.length()) {
			cond = " " + cond;
		}
		str.insert(oLoc, cond);
		return str.toString();
	}
}
