/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.utils.sql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JDBCTask {
    private static Logger log = Logger.getLogger(JDBCTask.class.getName());
    private boolean autocommit = false;
    private String driver = null;
    private String url = null;
    private String userId = null;
    private String password = null;

    public void setDriver(String driver) {
        this.driver = driver.trim();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    protected Connection getConnection() throws Exception {
        if (this.userId == null) {
            throw new Exception("UserId attribute must be set!");
        }
        if (this.password == null) {
            throw new Exception("Password attribute must be set!");
        }
        if (this.url == null) {
            throw new Exception("Url attribute must be set!");
        }
        try {
            log.info("connecting to " + this.getUrl());
            Properties info = new Properties();
            info.put("user", this.getUserId());
            info.put("password", this.getPassword());
            Connection conn = this.getDriver().connect(this.getUrl(), info);
            if (conn == null) {
                throw new SQLException("No suitable Driver for " + this.url);
            }
            conn.setAutoCommit(this.autocommit);
            return conn;
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    private Driver getDriver() throws Exception {
        if (this.driver == null) {
            throw new Exception("Driver attribute must be set!");
        }
        Driver driverInstance = null;
        try {
            driverInstance = (Driver)Class.forName(this.driver).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Class Not Found: JDBC driver " + this.driver + " could not be loaded", e);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Illegal Access: JDBC driver " + this.driver + " could not be loaded", e);
        }
        catch (InstantiationException e) {
            throw new Exception("Instantiation Exception: JDBC driver " + this.driver + " could not be loaded", e);
        }
        return driverInstance;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserid(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    static {
        log.setLevel(Level.WARNING);
    }
}

