/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.spring;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamedPreparedStatement {
    private String sql = null;
    private String preExecuteSql = "";
    private HashMap<String, ArrayList<IParamHolder>> paramListMap = new HashMap();
    private static final String PARAM_NAME_CHAR_PATTERN = "\\:[a-zA-Z0-9_]*";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private PreparedStatement pstmt;

    public NamedPreparedStatement(String sql) {
        Pattern pattern = Pattern.compile(PARAM_NAME_CHAR_PATTERN);
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            if (matcher.group().length() != 1) continue;
            throw new IllegalArgumentException(String.format("No parameter name. Parameter name is required after ':'. (%d column): %s", matcher.start(), sql));
        }
        this.sql = sql;
    }

    public void setString(String name, String ... values) {
        if (this.isEmpty(values)) {
            return;
        }
        ArrayList<1> holderlist = new ArrayList<1>();
        for (String value : values) {
            IParamHolder paramHolder = new IParamHolder(){
                private String value;

                @Override
                public void setValue(Object value) {
                    this.value = (String)value;
                }

                @Override
                public void set(PreparedStatement pstmt, int parameterIndex) throws SQLException {
                    if (this.value == null) {
                        pstmt.setNull(parameterIndex, 1);
                    } else {
                        pstmt.setString(parameterIndex, this.value);
                    }
                }

                @Override
                public String debug() {
                    if (this.value == null) {
                        return "null";
                    }
                    return String.format("'%s'", this.value);
                }
            };
            paramHolder.setValue(value);
            holderlist.add(paramHolder);
        }
        this.paramListMap.put(name, holderlist);
    }

    public void setInt(String name, Integer ... values) {
        if (this.isEmpty(values)) {
            return;
        }
        ArrayList<2> holderlist = new ArrayList<2>();
        for (Integer value : values) {
            IParamHolder paramHolder = new IParamHolder(){
                private Integer value;

                @Override
                public void setValue(Object value) {
                    this.value = (Integer)value;
                }

                @Override
                public void set(PreparedStatement pstmt, int parameterIndex) throws SQLException {
                    if (this.value == null) {
                        pstmt.setNull(parameterIndex, 4);
                    } else {
                        pstmt.setInt(parameterIndex, this.value);
                    }
                }

                @Override
                public String debug() {
                    if (this.value == null) {
                        return "null";
                    }
                    return String.valueOf(this.value);
                }
            };
            paramHolder.setValue(value);
            holderlist.add(paramHolder);
        }
        this.paramListMap.put(name, holderlist);
    }

    public void setDate(String name, Date ... values) {
        if (this.isEmpty(values)) {
            return;
        }
        ArrayList<3> holderlist = new ArrayList<3>();
        for (Date value : values) {
            IParamHolder paramHolder = new IParamHolder(){
                private Date value;

                @Override
                public void setValue(Object value) {
                    this.value = (Date)value;
                }

                @Override
                public void set(PreparedStatement pstmt, int parameterIndex) throws SQLException {
                    if (this.value == null) {
                        pstmt.setNull(parameterIndex, 91);
                    } else {
                        pstmt.setDate(parameterIndex, this.value);
                    }
                }

                @Override
                public String debug() {
                    if (this.value == null) {
                        return "null";
                    }
                    return String.format("TO_DATE('%s', 'yyyy-MM-dd'')", dateFormat.format(this.value));
                }
            };
            paramHolder.setValue(value);
            holderlist.add(paramHolder);
        }
        this.paramListMap.put(name, holderlist);
    }

    public ResultSet executeQuery(Connection con) throws SQLException {
        this.createStatment(con);
        return this.pstmt.executeQuery();
    }

    public int executeUpdate(Connection con) throws SQLException {
        this.createStatment(con);
        return this.pstmt.executeUpdate();
    }

    private void createStatment(Connection con) throws SQLException {
        System.out.println(this.debug());
        String statementSql = this.sql;
        ArrayList<IParamHolder> settingOrderList = new ArrayList<IParamHolder>();
        Pattern pattern = Pattern.compile(PARAM_NAME_CHAR_PATTERN);
        Matcher matcher = pattern.matcher(this.sql);
        while (matcher.find()) {
            String name = matcher.group().substring(1);
            if (!this.paramListMap.containsKey(name)) {
                throw new SQLException(String.format("Parameter value unknown. Parameter name: ?%s", name));
            }
            ArrayList<IParamHolder> paramHolderList = this.paramListMap.get(name);
            StringBuilder sb = new StringBuilder("?");
            for (int i = 1; i < paramHolderList.size(); ++i) {
                sb.append(", ?");
            }
            statementSql = statementSql.replaceFirst("\\:" + name, sb.toString());
            settingOrderList.addAll(paramHolderList);
        }
        if (this.preExecuteSql.equals(statementSql)) {
            this.pstmt.clearParameters();
        } else {
            this.close();
            this.pstmt = con.prepareStatement(statementSql);
        }
        for (int i = 0; i < settingOrderList.size(); ++i) {
            IParamHolder paramHolder = (IParamHolder)settingOrderList.get(i);
            paramHolder.set(this.pstmt, i + 1);
        }
    }

    public String debug() {
        String degugSql = this.sql;
        Pattern pattern = Pattern.compile(PARAM_NAME_CHAR_PATTERN);
        Matcher matcher = pattern.matcher(this.sql);
        while (matcher.find()) {
            String name = matcher.group().substring(1);
            if (!this.paramListMap.containsKey(name)) {
                degugSql = degugSql.replaceFirst("\\:" + name, "<no-setting>");
                continue;
            }
            ArrayList<IParamHolder> paramHolderList = this.paramListMap.get(name);
            StringBuilder sb = new StringBuilder(paramHolderList.get(0).debug());
            for (int i = 1; i < paramHolderList.size(); ++i) {
                sb.append(", " + paramHolderList.get(i).debug());
            }
            degugSql = degugSql.replaceFirst("\\:" + name, sb.toString());
        }
        return "[Debug SQL] " + degugSql;
    }

    public void clearParameters() throws SQLException {
        this.pstmt.clearParameters();
        this.paramListMap.clear();
        this.preExecuteSql = "";
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.pstmt.close();
            this.pstmt = null;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.pstmt == null || this.pstmt.isClosed();
    }

    private boolean isEmpty(Object[] list) {
        return list == null || list.length == 0;
    }

    private static interface IParamHolder {
        public void setValue(Object var1);

        public void set(PreparedStatement var1, int var2) throws SQLException;

        public String debug();
    }
}

