/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qimingx.spring;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseMultiActionController {
    public static final String JSON_CONTENT_TYPE = "text/javascript;charset=UTF-8";
    public static final String XML_CONTENT_TYPE = "application/xml;charset=UTF-8";
    public static final String HTML_CONTENT_TYPE = "text/html;charset=UTF-8";
    public static final String BINARY_CONTENT_TYPE = "application/x-download,charset=utf-8";
    private static final Log log = LogFactory.getLog(BaseMultiActionController.class);

    public static void sendJSON(HttpServletResponse resp, CharSequence json) {
        resp.setContentType(HTML_CONTENT_TYPE);
        try {
            resp.getWriter().write(json.toString());
            log.debug((Object)("response output:" + json));
        }
        catch (IOException e) {
            log.error((Object)("export JSON Error:" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)"", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void sendErrorJSON(HttpServletResponse resp, CharSequence json) {
        BaseMultiActionController.sendErrorJSON(resp, 400, json);
    }

    public static void sendErrorJSON(HttpServletResponse resp, int errorID, CharSequence json) {
        resp.setStatus(errorID);
        BaseMultiActionController.sendJSON(resp, json);
    }

    public static void sendError(HttpServletResponse resp, int errorID, CharSequence errorMsg) {
        resp.setContentType(HTML_CONTENT_TYPE);
        try {
            resp.sendError(errorID, errorMsg.toString());
        }
        catch (IOException e) {
            log.error((Object)("sendError Error:" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)"", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void sendBinaryStream(HttpServletResponse resp, String contentType, InputStream data) {
        block3: {
            try {
                int length;
                resp.setContentType(contentType);
                byte[] buf = new byte[1024];
                int len = 0;
                while ((length = data.read(buf)) >= 0) {
                    resp.getOutputStream().write(buf, 0, length);
                    len += length;
                }
                resp.setContentLength(len);
            }
            catch (IOException e) {
                log.error((Object)("sendBinaryStream Error:" + e.getLocalizedMessage()));
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBinaryStream(HttpServletResponse resp, File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] buf = new byte[(int)file.length()];
            int length = ((InputStream)in).read(buf);
            resp.getOutputStream().write(buf);
            resp.setContentLength(length);
        }
        catch (Exception e) {
            try {
                log.debug((Object)("sendBinaryStream.Error:" + e.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public static void download(HttpServletResponse resp, String fileName, byte[] data) {
        try {
            fileName = URLEncoder.encode(fileName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Encode FileName Error:" + e.getMessage()));
        }
        String content = "attachment; filename=" + fileName;
        resp.addHeader("Content-Disposition", content);
        resp.setCharacterEncoding("utf-8");
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BaseMultiActionController.sendBinaryStream(resp, "application/octet-stream", stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void download(HttpServletResponse resp, String fileName, File file) {
        try {
            fileName = URLEncoder.encode(fileName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Encode FileName Error:" + e.getMessage()));
        }
        String content = "attachment; filename=" + fileName;
        resp.addHeader("Content-Disposition", content);
        resp.setCharacterEncoding("utf-8");
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            BaseMultiActionController.sendBinaryStream(resp, "application/octet-stream", stream);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("FileNotFoundException for " + file.getAbsolutePath()));
            IOUtils.closeQuietly((InputStream)stream);
        }
        catch (Throwable e2) {
            log.error((Object)("warn\uff1a" + e2.getLocalizedMessage()));
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        IOUtils.closeQuietly((InputStream)stream);
    }
}

